set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9720166';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1000',
      '42341122',
      NULL,
      NULL,
      '04214241',
      NULL,
      '24021142',
      '01431100',
      '00032320',
      '30243323',
      NULL,
      '12101403',
      '04041323',
      '14232020',
      '04030112',
      NULL,
      '32003444',
      '22022213',
      '21022311',
      '44011303',
      NULL,
      '24411020',
      '02013304',
      NULL,
      '02111401',
      '24110111',
      '42214323',
      NULL,
      '40140200',
      '34241421',
      '43040110',
      '32432020',
      NULL,
      '32202031',
      '13204321',
      '44124304',
      '41403224',
      '03033302',
      '04324422',
      NULL,
      NULL,
      '42211330',
      NULL,
      NULL,
      '01402403',
      '004',
      '21',
      39.442069,
      NULL,
      '3300030',
      2.356482,
      0,
      0,
      NULL,
      '032433',
      NULL,
      ' 2- 4-1988',
      ' 1-24-1988',
      76,
      86,
      8.298546,
      3.988223,
      NULL,
      NULL,
      16,
      0.091923,
      9.376553,
      2.916820,
      NULL,
      NULL,
      27.902601,
      8,
      32.488015,
      8.590500,
      21,
      10,
      11,
      1,
      54,
      6.671495,
      8,
      9,
      1,
      20.439411,
      6.670092,
      75,
      NULL,
      120,
      70,
      ' 5- 5-1992',
      4.946558,
      NULL,
      26,
      6.134096,
      NULL,
      2,
      ' 5- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      15,
      16.166645,
      4.433547,
      NULL,
      1,
      ' 1- 8-1988',
      NULL,
      0,
      95.095309,
      3.435735,
      NULL,
      80,
      0,
      1,
      8,
      NULL,
      NULL,
      NULL,
      '10-24-1976',
      80,
      57,
      55,
      10.257530,
      87.174011,
      NULL,
      47.467695,
      6.844423,
      61,
      25,
      24.110781,
      95.170191,
      ' 5-15-1996',
      23.662163,
      1,
      1.283331,
      20.093478,
      NULL,
      45,
      8,
      '11-16-1996',
      2,
      3.499278,
      NULL,
      10,
      13.183094,
      0.099754,
      3.409571,
      NULL,
      2,
      0,
      NULL,
      0.190654,
      77,
      NULL,
      1,
      NULL,
      7.443135,
      0.660188,
      1.065196,
      NULL,
      0,
      ' 4-24-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      2,
      ' 1-13-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-21-1983',
      11.461615,
      ' 8-11-1984',
      NULL,
      2,
      ' 1- 9-1980',
      89,
      78.423028,
      ' 9- 0-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      19,
      NULL,
      23.804437,
      27.483355,
      38,
      ' 9-29-1983',
      1.187557,
      88.601767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


