set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8505385';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3240',
      '14100304',
      '40040043',
      NULL,
      NULL,
      '10241333',
      '34303102',
      '12141302',
      '00200113',
      '00440040',
      '10201310',
      '11122311',
      '34200411',
      NULL,
      '33224112',
      '02023304',
      '40132332',
      '34131202',
      '33014401',
      '01134111',
      '03240011',
      '14013404',
      '10321442',
      '34303144',
      '22101022',
      '24340330',
      NULL,
      '23103420',
      '34013140',
      '34410022',
      NULL,
      '12123042',
      '32010224',
      '41040144',
      NULL,
      '02031040',
      '34130042',
      '03020314',
      '21203101',
      '13322001',
      NULL,
      '12411114',
      '10001312',
      '30200313',
      '42224122',
      NULL,
      '21',
      28,
      11.728592,
      '4411301',
      0,
      0,
      NULL,
      NULL,
      '442214',
      3.092132,
      NULL,
      ' 6- 2-1998',
      248,
      5.109722,
      19,
      NULL,
      28.678631,
      10,
      34,
      23,
      21.532017,
      5,
      NULL,
      19.572294,
      13.186352,
      8.171840,
      29.917162,
      0,
      27.531875,
      1,
      NULL,
      20,
      22.397480,
      14,
      55.310382,
      2,
      NULL,
      NULL,
      NULL,
      65.495769,
      58,
      243,
      11.297542,
      NULL,
      NULL,
      57.962725,
      NULL,
      NULL,
      26,
      NULL,
      ' 3-19-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      39.280261,
      NULL,
      3,
      21,
      1.458877,
      ' 8-24-1978',
      0.977070,
      NULL,
      244.714471,
      1,
      0.830030,
      139.917122,
      0.081451,
      0.857393,
      47.688216,
      NULL,
      NULL,
      NULL,
      ' 5-20-1983',
      19,
      NULL,
      NULL,
      97,
      117,
      31,
      26.631750,
      4,
      98.852917,
      NULL,
      NULL,
      38,
      ' 9-28-2003',
      5.473400,
      22,
      NULL,
      57,
      54,
      NULL,
      2.252113,
      NULL,
      14.048565,
      NULL,
      ' 7- 3-1992',
      13.799493,
      29.942188,
      21.618247,
      14,
      19,
      6,
      0,
      18,
      0.923109,
      28,
      NULL,
      0.994435,
      18.944551,
      5.352420,
      0,
      1.348398,
      1.668649,
      1,
      ' 9-29-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11-20-1978',
      NULL,
      NULL,
      NULL,
      52.268378,
      ' 6- 9-1984',
      26,
      ' 6-27-1975',
      NULL,
      8,
      ' 1- 8-1994',
      71,
      58,
      ' 5- 9-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      20.335202,
      NULL,
      65,
      20,
      19,
      NULL,
      0.382977,
      55.598642,
      '11- 9-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


