set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611385';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3311',
      '24410202',
      '02304424',
      '10012232',
      NULL,
      '33234023',
      '01232243',
      '41041134',
      '00324304',
      NULL,
      '03411221',
      '11442120',
      '22313044',
      NULL,
      '20001243',
      '13433222',
      '10342344',
      '11011113',
      NULL,
      '34431044',
      '02424104',
      '13413042',
      '23232030',
      '41131233',
      '41210003',
      NULL,
      '31140440',
      '33232421',
      '33244010',
      NULL,
      '23221402',
      '23332320',
      '40214404',
      '23124042',
      '34022122',
      NULL,
      '42210002',
      '10113231',
      NULL,
      NULL,
      '31230014',
      '43024022',
      '30443010',
      NULL,
      '34011322',
      '422',
      '04',
      NULL,
      7,
      '1412141',
      NULL,
      0.044943,
      NULL,
      NULL,
      NULL,
      3,
      '11-25-2000',
      ' 5-15-1994',
      31.630222,
      NULL,
      8,
      5,
      NULL,
      6.971629,
      NULL,
      11.786805,
      10,
      10,
      38,
      NULL,
      15.859819,
      8,
      12,
      4.272421,
      13.759575,
      0,
      7.388522,
      7.536021,
      7,
      6,
      53.330467,
      NULL,
      0,
      NULL,
      147.235666,
      NULL,
      NULL,
      94,
      45,
      ' 1- 5-2001',
      54,
      17.122055,
      31.330789,
      7.516639,
      112.521353,
      46.828889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      62.127823,
      49.547991,
      15,
      34.360347,
      NULL,
      ' 8- 9-1994',
      0,
      NULL,
      151.304664,
      3.349206,
      0.611744,
      100,
      0.662895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-12-1976',
      57.702167,
      8.730589,
      NULL,
      28.169375,
      NULL,
      20.477185,
      43,
      NULL,
      90.770928,
      9,
      NULL,
      NULL,
      ' 9-10-2002',
      3,
      20,
      NULL,
      NULL,
      5.222437,
      6.112815,
      8.302300,
      ' 0- 8-1975',
      9.081328,
      NULL,
      ' 8- 8-1995',
      2.966671,
      10,
      NULL,
      NULL,
      1.269100,
      5,
      0,
      4,
      1.127711,
      NULL,
      8,
      2.476920,
      0.019209,
      10.339300,
      11,
      NULL,
      1,
      1.080269,
      ' 2-22-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      165,
      8.258681,
      ' 0-10-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-23-1979',
      0,
      ' 9- 2-1987',
      7.996205,
      13,
      ' 1-11-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      20,
      ' 5-26-1989',
      61.557194,
      5,
      15.069126,
      ' 5- 5-1978',
      0,
      86,
      '10-12-2003',
      11.996548,
      108,
      7,
      69.946426,
      ' 1- 8-1994',
      27.609795,
      0,
      32,
      ' 6-14-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


