set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611385';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1204',
      NULL,
      '34211003',
      NULL,
      '34032420',
      '03322332',
      '20424140',
      '12000011',
      '41422402',
      '23440423',
      '32232100',
      '03424023',
      NULL,
      '24210130',
      NULL,
      NULL,
      '24011132',
      '03130242',
      '04024141',
      '13221223',
      NULL,
      '34241213',
      NULL,
      '34124412',
      NULL,
      '20313121',
      '01301320',
      '22011112',
      '11114430',
      NULL,
      '43102000',
      '44414213',
      '34101023',
      '02010143',
      '43432224',
      '23424043',
      NULL,
      '33003440',
      NULL,
      '42240124',
      NULL,
      NULL,
      '43201201',
      NULL,
      '00020424',
      '331',
      '43',
      7,
      12,
      NULL,
      3.371329,
      23.429016,
      1,
      NULL,
      '204143',
      4,
      '10-12-1999',
      ' 8-26-1983',
      20,
      NULL,
      NULL,
      NULL,
      6,
      13.243227,
      35.002317,
      6,
      NULL,
      NULL,
      27.918930,
      3.971736,
      12,
      12,
      22.075045,
      NULL,
      10,
      4.465781,
      15.346105,
      NULL,
      16.239316,
      15,
      27,
      NULL,
      0,
      NULL,
      140.237328,
      14.863630,
      16.270136,
      168.143024,
      65,
      NULL,
      18.215067,
      2.350043,
      15.084582,
      12.385246,
      29,
      121.061003,
      ' 1- 8-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      18,
      NULL,
      7.035538,
      ' 1-13-1994',
      0.093034,
      0.547813,
      NULL,
      1.299427,
      0.071608,
      12.506427,
      0,
      1.492428,
      58,
      NULL,
      NULL,
      NULL,
      ' 4-15-1992',
      NULL,
      78,
      NULL,
      NULL,
      NULL,
      7,
      12.072192,
      48,
      70.228437,
      100,
      NULL,
      29,
      ' 2- 1-2000',
      NULL,
      24,
      8,
      16.157168,
      53,
      1.086091,
      0.938091,
      ' 3-22-2000',
      1,
      5.489827,
      ' 8-24-1976',
      5.104886,
      4.946728,
      NULL,
      10,
      2,
      8,
      NULL,
      10,
      0,
      23.717300,
      0.160738,
      1.259057,
      5,
      3.524757,
      0,
      1,
      1,
      1.493642,
      ' 3-20-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      6.563867,
      4,
      ' 5-10-1977',
      NULL,
      NULL,
      NULL,
      42,
      ' 1-20-1994',
      NULL,
      ' 6- 0-1998',
      NULL,
      6,
      ' 8-14-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      20,
      '11-23-2002',
      64.528581,
      12,
      28,
      '11-11-1975',
      0.829227,
      NULL,
      NULL,
      4.858938,
      157.819242,
      12,
      153,
      NULL,
      1.576493,
      1,
      109.503526,
      '10-29-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


