set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9898615';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '0',
      '3',
      '3',
      '3',
      '3',
      '2',
      NULL,
      '4',
      '0',
      '2',
      '3',
      '2',
      '1',
      '3',
      '2',
      '0',
      '0',
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '',
      NULL,
      '',
      '2',
      '0',
      '4',
      '4',
      NULL,
      '',
      '',
      '2',
      '0',
      '3',
      '2',
      '3',
      '2',
      '3',
      '0',
      NULL,
      '0',
      '1',
      '443',
      '01030014',
      NULL,
      19,
      '3121122',
      2.287691,
      NULL,
      0,
      NULL,
      '420234',
      NULL,
      '10-27-1994',
      NULL,
      86.226371,
      NULL,
      27.427835,
      21.947168,
      NULL,
      8.331815,
      NULL,
      2.104463,
      11,
      6,
      5,
      16,
      NULL,
      NULL,
      NULL,
      0,
      22.761330,
      1,
      14.073365,
      10.439375,
      33,
      8.954865,
      77,
      21.795247,
      0,
      132,
      145.575426,
      27.209930,
      NULL,
      28,
      183,
      ' 0-24-1975',
      43,
      46,
      5,
      17,
      176.078540,
      81,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      88,
      12,
      0.713981,
      NULL,
      6.131576,
      11,
      NULL,
      0,
      3.040860,
      178,
      1,
      NULL,
      147.873519,
      2.922994,
      1.283587,
      48.978214,
      NULL,
      NULL,
      NULL,
      ' 1-23-1989',
      107.010736,
      NULL,
      85.835832,
      64,
      NULL,
      1.805808,
      56.711449,
      NULL,
      38.809913,
      NULL,
      40,
      10.401537,
      '11- 3-1974',
      14,
      1.089770,
      4,
      56,
      36,
      14.811948,
      NULL,
      ' 0-13-2002',
      20.420861,
      NULL,
      ' 0-24-1992',
      2.993666,
      9.758338,
      7.159333,
      7.427528,
      NULL,
      11.779102,
      1.116687,
      14,
      NULL,
      NULL,
      0.147129,
      1,
      20,
      12,
      1,
      1.450070,
      NULL,
      0.222861,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      187.835868,
      5.701638,
      ' 0-18-1976',
      NULL,
      NULL,
      NULL,
      23.620988,
      ' 3-22-2000',
      NULL,
      ' 0-23-1983',
      8.825483,
      NULL,
      ' 3-27-1997',
      104,
      5.607071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      ' 7- 5-1982',
      70.628393,
      NULL,
      21.422131,
      NULL,
      1.187245,
      43,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


