set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126577';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '41334120',
      '34300142',
      NULL,
      NULL,
      NULL,
      '01140330',
      '10401202',
      '43023113',
      '42234214',
      '00014003',
      '24034424',
      '21232130',
      NULL,
      '43112211',
      '23113120',
      '22200423',
      NULL,
      '24324432',
      '41201233',
      '01313321',
      '02320224',
      '33031134',
      '24020004',
      '23000230',
      '22024321',
      '14111114',
      NULL,
      '11043112',
      '20000213',
      '30021112',
      '21340130',
      '24201132',
      '12410324',
      NULL,
      '33040134',
      '03132133',
      '02402441',
      NULL,
      NULL,
      NULL,
      '43230144',
      NULL,
      '21233114',
      '00041034',
      '104',
      '33',
      NULL,
      NULL,
      '0003333',
      NULL,
      0.796685,
      NULL,
      NULL,
      '342140',
      0,
      ' 7- 7-1978',
      ' 9-15-1990',
      106,
      NULL,
      34,
      7.650281,
      17.993586,
      NULL,
      3.376745,
      25.188407,
      NULL,
      16.544910,
      13.607850,
      12,
      10,
      16.558093,
      29.411617,
      NULL,
      17,
      0.083643,
      52,
      NULL,
      28,
      NULL,
      5,
      21,
      0.107470,
      39.001529,
      59.498876,
      101.162690,
      76,
      84.523526,
      227.354931,
      ' 3-11-1988',
      NULL,
      68,
      3,
      5,
      NULL,
      72,
      ' 2-27-1997',
      NULL,
      5,
      3,
      1,
      1,
      1.124738,
      3.861171,
      0,
      1.614936,
      0.003391,
      4.170199,
      0,
      0.122435,
      1.315944,
      0,
      1.792894,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-1988',
      50,
      20,
      10.209578,
      11,
      1,
      3,
      '10-28-1986',
      0.745820,
      1,
      136,
      1.616976,
      0.619339,
      89,
      2,
      0,
      69,
      NULL,
      NULL,
      213,
      NULL,
      44,
      NULL,
      21,
      81.927568,
      40.250866,
      36,
      30,
      55,
      0,
      NULL,
      62.314696,
      62,
      ' 5- 5-2003',
      1.305832,
      17,
      29,
      NULL,
      NULL,
      173.568426,
      14.272877,
      ' 2-20-1985',
      9.293540,
      25.049188,
      '10- 9-1984',
      3.063533,
      12,
      22.986194,
      9,
      3,
      13.124258,
      1.275256,
      17,
      0,
      101.395301,
      1,
      8.495928,
      22.897779,
      28,
      NULL,
      0.871962,
      0.027692,
      0,
      ' 1- 2-1990',
      4,
      NULL,
      2.899567,
      '10- 7-1987',
      163,
      NULL,
      ' 4-19-1988',
      19.012064,
      9.231692,
      ' 8-22-1984',
      3.214349,
      ' 9-21-1975',
      34.617227,
      ' 3- 1-2002',
      17.322027,
      NULL,
      '10-19-1980',
      NULL,
      NULL,
      NULL,
      4,
      17,
      ' 4-16-1975',
      1,
      16.199483,
      ' 1-21-1997',
      NULL,
      NULL,
      10,
      ' 6-25-1975',
      51,
      9.445527,
      1.915197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26);
commit;
end;
/


