set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9512600';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3214',
      '42341440',
      '23220210',
      '04101002',
      '14410234',
      '21122212',
      '02144013',
      '32113240',
      '23111234',
      '24223330',
      '43224242',
      '20412044',
      '12143322',
      '34310022',
      '12241213',
      NULL,
      '14432311',
      '44232403',
      NULL,
      '34322213',
      NULL,
      '23424113',
      '31120104',
      '21420144',
      '40404400',
      '43014334',
      '34020232',
      NULL,
      '41100122',
      '02022314',
      '30233030',
      NULL,
      '31413131',
      '01003141',
      NULL,
      '32222114',
      '03020034',
      '31243402',
      '24223023',
      '24021403',
      NULL,
      '24440203',
      '34123122',
      '13212200',
      '22011023',
      '222',
      '21',
      NULL,
      NULL,
      '1440101',
      2,
      1.648272,
      2,
      NULL,
      '202003',
      0,
      ' 5-17-1982',
      ' 9-20-1980',
      78.781269,
      NULL,
      36,
      NULL,
      9.776126,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      54,
      NULL,
      3,
      9.870708,
      12,
      10.676995,
      19.628772,
      5.599600,
      NULL,
      2,
      NULL,
      NULL,
      29,
      5,
      0,
      11.103786,
      150,
      32,
      184.322704,
      NULL,
      12.173770,
      ' 7- 5-1989',
      33.395643,
      3,
      23.440815,
      4,
      102.391496,
      22.302800,
      ' 5-16-2002',
      1,
      0,
      1,
      1.454164,
      3,
      0,
      1.934857,
      0,
      1.002436,
      1.570792,
      0,
      0,
      1,
      NULL,
      0.196486,
      NULL,
      0.101075,
      0.457602,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-20-1991',
      NULL,
      NULL,
      NULL,
      12,
      15,
      2.971322,
      ' 6- 1-2001',
      1,
      5.528505,
      158.363719,
      1,
      NULL,
      18,
      7.693580,
      1,
      70,
      NULL,
      NULL,
      NULL,
      ' 8-13-1991',
      69,
      1,
      74,
      50.751950,
      NULL,
      74,
      16.924746,
      62,
      23,
      58,
      NULL,
      NULL,
      ' 3-28-1991',
      NULL,
      24.506586,
      36,
      87.232928,
      NULL,
      172.728815,
      2,
      ' 1-23-1980',
      4,
      21,
      ' 8-20-1974',
      NULL,
      15,
      13,
      NULL,
      19,
      NULL,
      0,
      27.169176,
      1.665199,
      NULL,
      0.046094,
      1.961139,
      NULL,
      24.836184,
      0.850312,
      1,
      0.630653,
      3,
      ' 8-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      99,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 0-1990',
      23,
      '10- 9-1994',
      11.551930,
      NULL,
      '10-15-2000',
      111.865321,
      21.126159,
      NULL,
      5.987305,
      NULL,
      ' 0- 8-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.790818,
      ' 4-25-1979',
      NULL,
      54.717508,
      14.901391,
      ' 0-17-1976',
      0.435020,
      75.263386,
      ' 2- 1-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


