set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0241',
      '44323411',
      '10402000',
      '43111402',
      '02331440',
      '42112322',
      NULL,
      NULL,
      NULL,
      '00240002',
      '44242221',
      '20333031',
      '41231232',
      '14321041',
      '20421224',
      '04344141',
      '14344233',
      '41111012',
      '01010441',
      '23223222',
      '10311234',
      NULL,
      '44212131',
      '34111033',
      '44101310',
      NULL,
      NULL,
      NULL,
      '04403141',
      '40032410',
      '21014124',
      '10341040',
      '22243330',
      '31221043',
      '21332423',
      '13134041',
      '01032444',
      '34130440',
      '11022041',
      '01330330',
      '31241133',
      '42341120',
      '00221440',
      '04243321',
      '02004330',
      NULL,
      '20',
      11,
      4.833229,
      NULL,
      1.822029,
      0,
      NULL,
      NULL,
      '023140',
      5.395811,
      ' 1-16-1993',
      ' 0- 8-1986',
      39.129019,
      54,
      NULL,
      NULL,
      22.203782,
      21.783315,
      6.059440,
      17.815090,
      29,
      8.174769,
      19,
      12,
      43,
      17.888546,
      12.161966,
      10.355823,
      NULL,
      16,
      23,
      10.371379,
      42,
      25,
      58.723189,
      10.663353,
      0,
      101.177003,
      184.043714,
      53,
      NULL,
      176.544073,
      NULL,
      '10- 3-1998',
      26,
      7,
      NULL,
      15.367071,
      93,
      2,
      ' 0- 2-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.728246,
      8,
      2,
      2.943081,
      NULL,
      NULL,
      1.228589,
      1.440156,
      NULL,
      0.181577,
      0.688197,
      54.265205,
      1,
      0,
      70,
      NULL,
      NULL,
      NULL,
      ' 9-13-1999',
      3,
      52.280869,
      63,
      14.634719,
      30,
      10.893637,
      21,
      5.715084,
      57,
      48.745668,
      22.997108,
      49.088487,
      ' 9- 3-1976',
      10.900686,
      NULL,
      NULL,
      18,
      40.605509,
      14.688400,
      NULL,
      ' 0-14-1990',
      22.742166,
      2.489412,
      NULL,
      9,
      10.912958,
      6,
      11.177094,
      NULL,
      7,
      NULL,
      16,
      NULL,
      80,
      3,
      5.806840,
      21,
      13.623258,
      NULL,
      0,
      1.520185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.933644,
      '11- 5-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 2-1983',
      44.384927,
      ' 2-27-1983',
      15,
      7.572306,
      ' 9- 7-1984',
      109.579773,
      9.304204,
      '11- 4-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5.414301,
      '10- 0-1995',
      0,
      16.653748,
      36,
      ' 1-22-1987',
      1,
      NULL,
      NULL,
      0.595114,
      13,
      17,
      NULL,
      '11-29-2000',
      37.001190,
      1.567608,
      124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


