set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1031',
      '14011103',
      '33110340',
      '04021204',
      '01423232',
      '21124341',
      '12211424',
      '12002422',
      NULL,
      NULL,
      '02040124',
      '23034230',
      '24333024',
      '40113014',
      '34341313',
      '30022142',
      '11242121',
      '30233133',
      '11123130',
      '13230323',
      '33210020',
      NULL,
      '14402021',
      '42402224',
      '34434311',
      '10423040',
      NULL,
      '42301413',
      '00034312',
      '10001034',
      '30143132',
      '04413222',
      '14210413',
      '03024214',
      '40322212',
      '20024403',
      NULL,
      '12000110',
      '00424201',
      '32333130',
      '43231200',
      '10034422',
      NULL,
      NULL,
      '12101231',
      '422',
      '21',
      25,
      9.720260,
      '1404332',
      0.727051,
      10.188626,
      1,
      NULL,
      '240404',
      1,
      ' 9-10-1996',
      ' 9- 2-1999',
      103,
      164.552292,
      21,
      18,
      5,
      2,
      37.730475,
      2.030186,
      5,
      27,
      5.950434,
      19.164386,
      11,
      NULL,
      9.685252,
      9,
      NULL,
      11.769457,
      13,
      24,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      180,
      99.356789,
      61.680797,
      NULL,
      101.298323,
      ' 1-28-1988',
      NULL,
      53.018876,
      8.388776,
      25.846604,
      NULL,
      190.022694,
      ' 5-16-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.309468,
      NULL,
      14,
      6,
      11.480012,
      ' 5-24-1979',
      1.820699,
      1,
      184,
      0.892031,
      NULL,
      75.150184,
      0,
      0,
      56,
      NULL,
      NULL,
      NULL,
      ' 1- 6-2003',
      86.448493,
      33,
      78,
      55,
      85.898551,
      NULL,
      81.943894,
      NULL,
      74,
      68.069019,
      25.841267,
      79,
      ' 2- 9-1989',
      12.206335,
      2,
      NULL,
      7,
      4,
      23,
      9,
      ' 4-24-1998',
      8.543921,
      3.154341,
      ' 9-29-1975',
      2,
      8,
      12.717919,
      NULL,
      15.098240,
      4.111375,
      1,
      5.808529,
      1.241709,
      73.866752,
      1.499496,
      2.700468,
      2.864374,
      24.080081,
      0,
      1,
      0,
      0.137742,
      '11- 9-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      200,
      NULL,
      ' 9-16-1987',
      NULL,
      NULL,
      NULL,
      22.224260,
      ' 0-23-1998',
      19,
      ' 4-28-1979',
      NULL,
      NULL,
      ' 8-26-1976',
      89.169105,
      85,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      8.309321,
      ' 7-16-1992',
      27.432454,
      37,
      19.640778,
      ' 5-21-1990',
      0.513257,
      45,
      ' 1- 1-1986',
      6.908340,
      26.737680,
      11.812191,
      49.872063,
      '11-26-1980',
      53.892613,
      1,
      NULL,
      ' 2- 4-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


