set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649566';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '4',
      '1',
      '3',
      '0',
      '2',
      '3',
      '4',
      NULL,
      '3',
      '1',
      '1',
      NULL,
      '3',
      '3',
      '1',
      '3',
      '2',
      '2',
      '1',
      '3',
      NULL,
      '2',
      NULL,
      '3',
      NULL,
      '2',
      '3',
      '4',
      '4',
      '4',
      '',
      '',
      NULL,
      '4',
      '4',
      '4',
      '4',
      '0',
      '1',
      '1',
      '4',
      '2',
      '3',
      '323',
      '31310040',
      76.922877,
      49.829385,
      NULL,
      1.217882,
      9,
      3,
      NULL,
      NULL,
      NULL,
      ' 0-18-1978',
      ' 3-15-1976',
      295,
      27.651546,
      3,
      9,
      38.089938,
      2,
      83,
      21,
      3,
      4,
      29,
      6.591214,
      NULL,
      NULL,
      1,
      13,
      23.882489,
      11.966603,
      69.276445,
      NULL,
      46,
      13,
      4.676605,
      13.090033,
      1.231070,
      113,
      161,
      19,
      NULL,
      NULL,
      124,
      ' 2- 5-1987',
      14.576167,
      34.995685,
      NULL,
      13,
      181.295993,
      124,
      ' 1-17-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.145248,
      1.733274,
      NULL,
      0,
      0.253299,
      NULL,
      2,
      1,
      96,
      1,
      1,
      10.670883,
      0,
      0,
      33.282313,
      NULL,
      NULL,
      NULL,
      NULL,
      35.343647,
      61.675367,
      63,
      40.797053,
      NULL,
      4.090795,
      NULL,
      NULL,
      57.145945,
      37.103546,
      72,
      18,
      '10- 0-1985',
      8.569616,
      9.973620,
      0.966693,
      26.545867,
      17.585291,
      15,
      7,
      ' 0- 9-1978',
      3.338260,
      17,
      ' 8- 7-1992',
      NULL,
      16.484756,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      10.582156,
      1,
      91,
      0,
      0.819655,
      9.735072,
      NULL,
      0,
      1.952849,
      0,
      1,
      ' 6-13-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      145,
      1.140703,
      ' 6-26-1999',
      NULL,
      NULL,
      NULL,
      10,
      ' 6-29-1979',
      4,
      ' 6-24-1982',
      7,
      6,
      NULL,
      138.055123,
      120,
      '11-18-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4.932211,
      ' 9- 1-1997',
      7.423731,
      39.240967,
      51,
      '11-12-1979',
      0,
      132,
      NULL,
      0.914445,
      35.563549,
      12.686385,
      39.337769,
      NULL,
      43.743344,
      1,
      66.557134,
      ' 5- 9-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


