set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8808376';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '11033401',
      '32143203',
      '33301240',
      '14320102',
      '43303444',
      '44010434',
      NULL,
      '24323324',
      NULL,
      '04241011',
      '12403324',
      NULL,
      '30021204',
      NULL,
      '33040441',
      '22011414',
      '20103310',
      NULL,
      NULL,
      '34132023',
      NULL,
      '10111430',
      '13314130',
      '23304333',
      '10000013',
      '32223430',
      '40131411',
      '22302110',
      '44004140',
      NULL,
      '04323022',
      '23143410',
      '22311400',
      NULL,
      '03343011',
      '00214224',
      NULL,
      '11102242',
      NULL,
      NULL,
      NULL,
      NULL,
      '11442430',
      '',
      '',
      NULL,
      NULL,
      '0442304',
      0,
      0.957284,
      NULL,
      NULL,
      '431111',
      0.586737,
      ' 1-22-1996',
      ' 2- 5-1983',
      58,
      NULL,
      NULL,
      13,
      9.312830,
      4,
      63.698987,
      9.560834,
      3.629413,
      16,
      24,
      15.987014,
      14.457353,
      NULL,
      20.655964,
      19,
      7,
      8,
      51.454665,
      14,
      41,
      16.290651,
      NULL,
      13.633360,
      NULL,
      97.095249,
      34.157825,
      7,
      36,
      18,
      29.278854,
      ' 8- 5-1989',
      51,
      13.932842,
      4,
      25,
      45,
      166.284896,
      ' 9-11-1975',
      0,
      6.724354,
      11,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.656604,
      0.071874,
      0,
      NULL,
      5,
      1.215892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 4-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-23-1999',
      21,
      NULL,
      7.113776,
      96.058367,
      86,
      17.732705,
      88.468543,
      16.323814,
      15.921496,
      38.430770,
      0.178322,
      NULL,
      ' 4-14-1988',
      26,
      13.958766,
      27.097745,
      64,
      89,
      99.027913,
      6.919738,
      ' 5- 7-1997',
      NULL,
      12,
      '10-10-1986',
      7.514821,
      NULL,
      6.069252,
      NULL,
      17.088746,
      1,
      NULL,
      11.858057,
      NULL,
      NULL,
      4,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-28-1981',
      NULL,
      75.925663,
      NULL,
      0,
      17,
      19,
      5.982150,
      ' 4- 3-2000',
      19,
      NULL,
      71,
      ' 5-10-1980',
      NULL,
      NULL,
      NULL,
      52.313407,
      1,
      90.555884,
      72.954568,
      16.640916,
      59.094059,
      NULL,
      8.856529,
      5.332840,
      3,
      NULL,
      45,
      1,
      0.959676,
      43.788152,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767698,
      61.138511,
      1.494053,
      9.586675,
      241.302789,
      NULL,
      5,
      NULL,
      0.658181,
      58,
      0,
      0,
      0,
      0,
      NULL,
      1.727631,
      9.257897,
      3,
      86,
      5.447973,
      96.303795,
      7,
      0,
      NULL,
      13.967938,
      1,
      0.942660,
      1.691749,
      1.176614,
      1.583818,
      20.700448,
      0,
      NULL,
      0,
      1,
      NULL,
      8,
      4.528250,
      22,
      91.022450,
      NULL,
      6.676479,
      84,
      9,
      4.134447,
      0,
      3.900376,
      1.545545,
      NULL,
      0.032620,
      1.414124,
      57.056462,
      ' 3-26-1975',
      ' 5-10-1984',
      '11-24-2001',
      ' 4-15-2000',
      '10- 2-1978',
      ' 6- 6-1996',
      NULL,
      NULL);
commit;
end;
/


