set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9226282';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3010',
      NULL,
      NULL,
      '44001010',
      '02220134',
      '23242233',
      '12314010',
      NULL,
      '02400002',
      NULL,
      '04033043',
      '12024202',
      '31302024',
      NULL,
      '13102241',
      NULL,
      '03434413',
      '30312324',
      '03001432',
      '41102234',
      '40202112',
      NULL,
      NULL,
      '13004430',
      '21230032',
      '42342412',
      '11122343',
      '03133302',
      NULL,
      '13430333',
      '22344413',
      '04242021',
      '33043040',
      '23004412',
      NULL,
      NULL,
      '40330134',
      NULL,
      '03421344',
      '40043004',
      '30201214',
      NULL,
      '41210104',
      '42043024',
      '12334344',
      '323',
      '41',
      NULL,
      NULL,
      '2131022',
      3,
      1.327928,
      0,
      NULL,
      '234200',
      2,
      ' 9-15-1987',
      ' 9-26-1999',
      47.805049,
      NULL,
      NULL,
      7.102721,
      24.649963,
      9.625864,
      42.913543,
      3.551288,
      28,
      22,
      0.686343,
      NULL,
      0.742609,
      NULL,
      2,
      8.221329,
      7,
      1.116751,
      10,
      34.810464,
      28.567754,
      NULL,
      21,
      14,
      2.264295,
      60.211097,
      65.854282,
      NULL,
      188.781416,
      15.706618,
      91.376653,
      '11-21-1983',
      12.722363,
      68.280247,
      NULL,
      0.626954,
      70.064494,
      213.782273,
      ' 1-22-1981',
      3.150091,
      2.649192,
      NULL,
      0.970270,
      1,
      1.310637,
      NULL,
      0.837414,
      2,
      1,
      1,
      0,
      0,
      0,
      0.035281,
      NULL,
      1,
      1,
      1.666492,
      1.537127,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 8-1990',
      36,
      0.994031,
      7.603640,
      2,
      3,
      6,
      ' 4- 2-1984',
      0,
      0.489427,
      NULL,
      1.740675,
      NULL,
      62,
      NULL,
      0.975279,
      104,
      1.488358,
      0.822266,
      NULL,
      ' 9- 2-1999',
      123,
      40.527730,
      62,
      23.547054,
      NULL,
      NULL,
      58,
      NULL,
      NULL,
      16.788800,
      NULL,
      70,
      '10- 0-1986',
      3.648753,
      18,
      NULL,
      NULL,
      NULL,
      122,
      NULL,
      ' 3-10-1985',
      23.452574,
      8,
      ' 5-17-1983',
      7.894253,
      9,
      8,
      NULL,
      NULL,
      3.651017,
      0,
      15.250223,
      1,
      33,
      1,
      0.271986,
      9,
      28.996904,
      1,
      1,
      0,
      0,
      '10- 3-1996',
      4.708452,
      0.800444,
      2.025041,
      NULL,
      NULL,
      NULL,
      ' 8- 3-2000',
      13.502034,
      NULL,
      ' 1-10-1979',
      NULL,
      ' 3-10-1983',
      5.688376,
      NULL,
      NULL,
      15.772529,
      ' 2- 1-1989',
      12,
      34.351147,
      NULL,
      4,
      10,
      ' 7-29-1990',
      0,
      1.812974,
      '11- 0-1995',
      NULL,
      1,
      NULL,
      ' 7-24-1975',
      18,
      39.267050,
      16,
      '10-15-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5);
commit;
end;
/


