set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '20330443',
      '33200420',
      '12434142',
      '43403213',
      '00333321',
      '20321411',
      '24420222',
      '13323341',
      '34321413',
      '03423400',
      '34343420',
      '43100321',
      NULL,
      '30101023',
      '22330210',
      '12022240',
      '44011431',
      NULL,
      '03244004',
      '14111243',
      '42032041',
      NULL,
      '43400004',
      '40402213',
      '03220331',
      '41201111',
      NULL,
      '03030343',
      '02101424',
      '11333402',
      '42322031',
      NULL,
      '12340423',
      '22411132',
      '24112223',
      '11003012',
      NULL,
      '11132310',
      NULL,
      '13301344',
      '32440012',
      NULL,
      NULL,
      NULL,
      '443',
      '22',
      15,
      0,
      '2220203',
      2.398501,
      1,
      2,
      NULL,
      '010441',
      NULL,
      ' 9-20-1982',
      ' 2-14-2002',
      81,
      90.483883,
      14.518530,
      6,
      14.627921,
      6,
      NULL,
      2.570869,
      15,
      3,
      26.831955,
      5,
      NULL,
      3,
      17.280720,
      2,
      15,
      13,
      14.152698,
      NULL,
      33,
      10,
      107.652124,
      20.364531,
      1,
      NULL,
      117,
      10,
      NULL,
      NULL,
      158,
      ' 5- 9-1975',
      25.698349,
      9.469361,
      15.128166,
      19,
      77,
      98,
      ' 7-27-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.427982,
      3.369617,
      171,
      NULL,
      3,
      80.942750,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-16-1975',
      99.249808,
      47,
      82.524920,
      36.088294,
      13,
      NULL,
      25,
      3.307170,
      20.384835,
      65.951956,
      14.207605,
      43.877638,
      NULL,
      3.175324,
      5,
      5,
      21.639499,
      37,
      2,
      0,
      '11- 4-1980',
      3,
      1,
      ' 5-19-1982',
      NULL,
      11.191693,
      0,
      0,
      6,
      9,
      NULL,
      1.922275,
      0,
      22,
      1.719190,
      2.536741,
      NULL,
      3.685254,
      6,
      7,
      0,
      3.324502,
      ' 8-24-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      0.799428,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      ' 8- 1-2001',
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      90,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.142340,
      ' 5-26-1975',
      35,
      0.431711,
      NULL,
      ' 5- 9-1985',
      NULL,
      NULL,
      NULL,
      5,
      178.768913,
      5,
      NULL,
      ' 3-22-2002',
      67.441633,
      0,
      90,
      '11-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


