set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '3',
      '0',
      NULL,
      '1',
      '0',
      '3',
      '3',
      NULL,
      '2',
      '0',
      '4',
      '2',
      '0',
      '3',
      '0',
      '3',
      '1',
      NULL,
      '2',
      '4',
      '4',
      '3',
      '',
      '4',
      '',
      '4',
      '3',
      '0',
      '1',
      '0',
      '',
      NULL,
      '1',
      '2',
      '4',
      NULL,
      '3',
      '1',
      '1',
      '3',
      '2',
      '0',
      NULL,
      '440',
      '12143334',
      5,
      37,
      '0400224',
      1,
      38,
      NULL,
      NULL,
      '022443',
      0,
      NULL,
      ' 0- 9-2000',
      43.473201,
      200.349180,
      2,
      10.161189,
      NULL,
      6,
      28.821947,
      5,
      NULL,
      3,
      33,
      12,
      9,
      5,
      28.067257,
      11,
      10,
      4.033644,
      37,
      8.025296,
      NULL,
      0,
      145,
      0.730274,
      1,
      36,
      52.683352,
      22,
      133,
      11.736396,
      2,
      ' 0-13-1999',
      14.498744,
      21,
      21.814442,
      13.558113,
      142.408266,
      NULL,
      ' 2- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74.598392,
      32,
      30.760022,
      26.930778,
      5,
      2,
      NULL,
      NULL,
      0,
      98.580660,
      0.726366,
      0.704183,
      66,
      1,
      NULL,
      49.808190,
      NULL,
      NULL,
      NULL,
      ' 7-15-2002',
      17.664065,
      103,
      26,
      7,
      87.274366,
      110,
      100.911100,
      52.544369,
      64,
      12.790968,
      9,
      81.156959,
      ' 9-22-1986',
      15.147237,
      10,
      NULL,
      NULL,
      8.403489,
      NULL,
      6,
      ' 6- 0-1986',
      NULL,
      12.101096,
      ' 5- 5-1992',
      4,
      0,
      2.913556,
      6.643736,
      0,
      0.220468,
      4,
      0,
      2.574770,
      31,
      3,
      1,
      17,
      13.139110,
      0.023216,
      3.725525,
      1,
      0.904421,
      ' 1-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      106,
      NULL,
      ' 4-14-1982',
      NULL,
      NULL,
      NULL,
      42.239439,
      ' 4- 7-2003',
      4,
      '11- 9-1984',
      6.404448,
      6,
      ' 1-17-1989',
      49.505593,
      NULL,
      ' 7-14-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.818275,
      ' 4- 0-1978',
      3.193790,
      34.425926,
      35.051365,
      NULL,
      5.214940,
      250,
      NULL,
      2,
      22,
      NULL,
      30.959333,
      ' 5-14-1979',
      48,
      1.069181,
      35.439999,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


