set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9699006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '0',
      '3',
      '4',
      '3',
      '1',
      '4',
      '2',
      '3',
      '0',
      '0',
      '1',
      NULL,
      '4',
      NULL,
      '1',
      '2',
      '2',
      NULL,
      '2',
      NULL,
      '0',
      '4',
      '',
      '1',
      NULL,
      '4',
      NULL,
      '0',
      '1',
      '3',
      NULL,
      '',
      '2',
      '4',
      '4',
      '1',
      NULL,
      '4',
      '2',
      NULL,
      '1',
      '2',
      '2',
      '114',
      '30202204',
      2,
      56,
      '4130310',
      1,
      NULL,
      NULL,
      0,
      '401130',
      2,
      '11-29-1978',
      '10-23-1977',
      NULL,
      238,
      21.549346,
      NULL,
      17,
      6.741776,
      NULL,
      NULL,
      7.497860,
      2.728483,
      5.663968,
      4.339014,
      19.848979,
      7,
      9,
      13,
      11.102545,
      NULL,
      6.824814,
      9,
      25,
      2.906959,
      120.568854,
      14.186684,
      1,
      NULL,
      NULL,
      30,
      41,
      123,
      NULL,
      ' 5-28-1986',
      21,
      19,
      5.422726,
      30,
      NULL,
      192,
      ' 1- 5-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      7.457117,
      NULL,
      2.708975,
      29.147900,
      NULL,
      ' 3- 6-1984',
      0,
      1,
      180.432998,
      0,
      2,
      NULL,
      0.360619,
      1.441522,
      68.385332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.557794,
      NULL,
      119.988490,
      103.708358,
      NULL,
      61.284425,
      63,
      13.352605,
      53,
      92,
      NULL,
      2,
      5.583586,
      9,
      12.531138,
      NULL,
      3,
      1.033084,
      ' 5-24-1988',
      6.253804,
      NULL,
      NULL,
      4.583999,
      12.986023,
      1.656807,
      3.945721,
      10,
      7,
      0.098509,
      7.194825,
      NULL,
      59.887023,
      1.254769,
      0,
      NULL,
      13.406786,
      5.875301,
      NULL,
      NULL,
      1,
      ' 1-27-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      80.621708,
      7,
      '10-24-1988',
      NULL,
      NULL,
      NULL,
      19,
      ' 3-17-2001',
      17,
      NULL,
      NULL,
      11.465396,
      NULL,
      12,
      75.561725,
      ' 2-11-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      7.917117,
      NULL,
      56,
      0.072169,
      2.832581,
      ' 5- 2-1976',
      3.234729,
      99,
      '11-15-1996',
      7,
      23,
      14,
      18.505475,
      NULL,
      62.187455,
      1.028874,
      126.903117,
      ' 6- 7-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


