set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7211810';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4322',
      '30331043',
      '13321311',
      '41003021',
      '30333410',
      NULL,
      '04101104',
      '20140104',
      NULL,
      '03203321',
      '24300313',
      NULL,
      '22014331',
      '20014120',
      NULL,
      '10300434',
      '10244412',
      '40423131',
      '03003342',
      '21003030',
      NULL,
      '03142423',
      '23223042',
      NULL,
      '24302140',
      NULL,
      '21212242',
      NULL,
      '31144403',
      '32221341',
      '42133320',
      '32032130',
      NULL,
      '31214141',
      '42034213',
      NULL,
      '01223222',
      '30404141',
      NULL,
      '23202311',
      NULL,
      '42430202',
      '24302232',
      '01344403',
      '32004333',
      '',
      '',
      NULL,
      NULL,
      '4330321',
      NULL,
      0.129260,
      1,
      NULL,
      NULL,
      NULL,
      '10-23-1992',
      '10- 5-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.576325,
      3,
      2.021635,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.982409,
      3,
      NULL,
      0,
      1.018312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      89,
      64,
      70,
      17.173006,
      80,
      89,
      NULL,
      71,
      NULL,
      78.109268,
      86,
      93.795637,
      ' 1-16-1983',
      24,
      21,
      6,
      48,
      39,
      39,
      4,
      ' 1-14-1980',
      10.613131,
      3.573649,
      ' 8-17-1998',
      11.204728,
      3,
      6,
      NULL,
      8.608858,
      2,
      NULL,
      18,
      NULL,
      20,
      0.667109,
      0.617069,
      2.239193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-20-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      19.128017,
      8,
      NULL,
      1.245963,
      8.025322,
      ' 3- 4-1974',
      6.564801,
      NULL,
      12,
      1.232786,
      ' 4-20-1985',
      0.014092,
      1.514263,
      44,
      ' 4- 8-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      7.964568,
      12.547839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.567497,
      3.952324,
      8.688155,
      0,
      2.238404,
      NULL,
      NULL,
      3.514061,
      104.181794,
      4,
      0,
      NULL,
      8.926576,
      1.618549,
      42,
      1,
      61,
      1.492512,
      0,
      1,
      NULL,
      1,
      0.203145,
      33.507010,
      43,
      5.716119,
      3.863367,
      NULL,
      NULL,
      1.489253,
      0,
      NULL,
      NULL,
      NULL,
      2,
      25.936813,
      1.311587,
      43.933161,
      0,
      NULL,
      NULL,
      1.563775,
      29,
      4.029025,
      0,
      27,
      NULL,
      49.100984,
      3,
      54.054723,
      8.405071,
      11.757105,
      1,
      8,
      NULL,
      0.150189,
      1.457727,
      1,
      8,
      NULL,
      ' 0- 0-1987',
      ' 5- 6-1978',
      ' 8-18-1982',
      '11- 9-1981',
      '10-20-2002',
      ' 7-22-1977',
      NULL);
commit;
end;
/


