set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4440',
      '21214120',
      '13423440',
      '14113300',
      NULL,
      '11231024',
      '00120402',
      '34330041',
      '14441441',
      '43123324',
      '03403233',
      '20420340',
      '03103422',
      '31314213',
      '24134402',
      '40230431',
      '30442314',
      '13421301',
      NULL,
      '02144043',
      '33244314',
      '11313300',
      '10313241',
      '20011201',
      '44040220',
      '22300322',
      '20013103',
      '42014234',
      NULL,
      '30221101',
      '14124313',
      '34110101',
      '23400103',
      '42444204',
      '10242334',
      '12113440',
      '33124114',
      '31331102',
      '01103333',
      NULL,
      '14013143',
      '34334222',
      '20320220',
      '00303240',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1311240',
      1.427391,
      0.326648,
      3,
      NULL,
      '343102',
      1,
      ' 5- 0-2000',
      NULL,
      NULL,
      NULL,
      41,
      29,
      NULL,
      12,
      73.846652,
      2.255708,
      28.987894,
      11,
      21.531783,
      7,
      4,
      10,
      24,
      13,
      5.255360,
      13,
      68.751034,
      2.019848,
      40.303766,
      NULL,
      NULL,
      8.219479,
      NULL,
      61,
      134,
      4,
      112.770620,
      115,
      NULL,
      ' 5-25-2001',
      29.669658,
      8.453877,
      19,
      NULL,
      70,
      176.955185,
      NULL,
      1,
      3.835465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.727020,
      NULL,
      1.102657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 5-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1987',
      14,
      86.157329,
      51,
      89.131121,
      112.075780,
      38,
      NULL,
      39.192717,
      72.805043,
      103,
      59.885551,
      NULL,
      '11-26-2001',
      16,
      NULL,
      1,
      NULL,
      46,
      0,
      NULL,
      ' 1-20-1984',
      4.289187,
      0.884083,
      ' 7-23-1994',
      0,
      16.805450,
      NULL,
      4,
      2.792941,
      13.375759,
      NULL,
      14.003038,
      NULL,
      115.165974,
      0,
      8.352160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-19-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      27,
      56,
      NULL,
      NULL,
      88.851140,
      ' 5-11-1990',
      8.627408,
      43,
      22.632017,
      6,
      ' 9-18-1998',
      10,
      1,
      NULL,
      ' 9- 5-1996',
      NULL,
      NULL,
      NULL,
      52.026018,
      155.685715,
      NULL,
      NULL,
      10.043123,
      86,
      11,
      NULL,
      5,
      NULL,
      3,
      24,
      1,
      NULL,
      NULL,
      1.247905,
      0.795716,
      28.527116,
      NULL,
      0.417231,
      NULL,
      NULL,
      3.267737,
      171.363507,
      56.661693,
      14.375884,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.328184,
      0,
      NULL,
      1.059306,
      NULL,
      54,
      47,
      22,
      79,
      34,
      1,
      1,
      15,
      0,
      NULL,
      6.136197,
      8.402918,
      0,
      NULL,
      5,
      10,
      1.292792,
      2.165641,
      27,
      33,
      11,
      30,
      8,
      40.916172,
      23,
      NULL,
      12.796704,
      1.081187,
      0.627805,
      0.753090,
      1,
      0,
      0.096615,
      0,
      37.862307,
      NULL,
      '10-25-1981',
      ' 5-28-1976',
      NULL,
      '11-29-1999',
      ' 5-12-1991',
      ' 8-25-1997',
      NULL);
commit;
end;
/


