set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1322',
      '13311430',
      '12333433',
      '22033412',
      NULL,
      '21321101',
      NULL,
      '24004224',
      NULL,
      NULL,
      '21440113',
      '02202114',
      NULL,
      NULL,
      NULL,
      '40011423',
      '00324244',
      NULL,
      '02323132',
      '11213101',
      NULL,
      '32430214',
      '14014322',
      '22242300',
      '04233340',
      NULL,
      '44440203',
      '03022344',
      NULL,
      '41202430',
      '01321102',
      '14010314',
      '23230132',
      '34300231',
      '10121340',
      '10332331',
      '04133204',
      '40310032',
      '40024422',
      '03210322',
      NULL,
      NULL,
      '43204124',
      '21432201',
      NULL,
      '342',
      '43',
      NULL,
      NULL,
      '1112100',
      0,
      92.990008,
      2,
      NULL,
      '224114',
      2.107871,
      ' 4-21-1999',
      ' 9-19-1988',
      33,
      NULL,
      17,
      4.764844,
      17,
      12.446182,
      59,
      13,
      9,
      20.753736,
      NULL,
      12.448934,
      35.158268,
      9.322676,
      5.105220,
      1,
      10.279138,
      25,
      67.858312,
      12,
      NULL,
      11,
      122,
      18,
      NULL,
      92,
      231,
      68,
      22.013403,
      246,
      157.607962,
      ' 1- 8-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144891,
      4,
      0.729793,
      2.796130,
      0,
      5,
      1,
      2.349522,
      NULL,
      0,
      5,
      1.902391,
      1,
      0,
      0,
      1.728913,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-28-2002',
      78,
      1,
      6,
      3,
      9,
      NULL,
      ' 7-23-1990',
      0,
      1.608495,
      48.020361,
      2,
      1.857955,
      125.818850,
      0,
      0.137284,
      24.242281,
      1,
      0.172429,
      NULL,
      ' 9- 3-1974',
      NULL,
      80,
      64,
      60.487582,
      43,
      71,
      67,
      82,
      NULL,
      25,
      NULL,
      59.581934,
      ' 1-29-1975',
      22,
      2,
      31.420736,
      84.231729,
      13.441182,
      NULL,
      3,
      '10-15-1998',
      NULL,
      2,
      ' 9-11-1996',
      0.576995,
      2.332814,
      NULL,
      8.813766,
      1,
      7.056068,
      1,
      7,
      1.179277,
      8.339407,
      4.307094,
      8.023490,
      7.847693,
      7.651982,
      3.708872,
      2.727031,
      0.836417,
      NULL,
      NULL,
      3,
      NULL,
      3,
      ' 9- 3-1975',
      NULL,
      12,
      '11-21-1983',
      NULL,
      NULL,
      NULL,
      25,
      ' 0- 5-1979',
      17.367139,
      '11-24-2003',
      0,
      0,
      ' 3-23-1974',
      29,
      28.946173,
      ' 9-17-1995',
      6,
      NULL,
      ' 5-27-1984',
      0.676343,
      2.625650,
      ' 3- 1-1983',
      0,
      3,
      5,
      ' 6-18-1998',
      12,
      23,
      15,
      ' 5-28-1990',
      0,
      90,
      '10-11-1996',
      7.765839,
      9.746404,
      10,
      22.228908,
      NULL,
      17.538704,
      0.328004,
      95,
      ' 2- 9-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.849302);
commit;
end;
/


