set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4432',
      '14142141',
      '13122042',
      '03004110',
      NULL,
      '31043231',
      '21301314',
      '33412200',
      NULL,
      '14041412',
      '04402241',
      '42444113',
      '32300312',
      '21132322',
      '43041344',
      '04430434',
      '42212244',
      '22034410',
      '12020431',
      '00210211',
      '10032234',
      '23311301',
      '02010330',
      '34412143',
      '34341440',
      '00241132',
      NULL,
      NULL,
      '13142301',
      '32220201',
      '14421421',
      '30123124',
      '40434043',
      '21431232',
      '21210404',
      '21421330',
      '21114444',
      '21342043',
      '21040001',
      '20020432',
      '24400024',
      '22311411',
      '20341040',
      '22341202',
      '12201032',
      '220',
      '20',
      23,
      8,
      '0342230',
      1.764767,
      158.034585,
      0,
      NULL,
      '244222',
      3.667280,
      ' 3-19-1979',
      ' 4- 9-1993',
      16,
      NULL,
      27.703427,
      28,
      33.199266,
      21,
      112.151481,
      NULL,
      23,
      21,
      4,
      3,
      0,
      1.762606,
      34.565322,
      11.478855,
      26,
      NULL,
      47.992752,
      NULL,
      NULL,
      11.948276,
      25.869325,
      6.750432,
      1,
      17.422295,
      NULL,
      77.406961,
      105,
      57.834399,
      112,
      ' 5-19-1974',
      NULL,
      57.933300,
      4,
      16.125064,
      60.525013,
      201.028993,
      ' 9- 5-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      84,
      23.360528,
      5.341657,
      13,
      8.947369,
      9,
      ' 3- 5-1995',
      0,
      NULL,
      179,
      0,
      2,
      13,
      1.017367,
      0.261494,
      6,
      NULL,
      NULL,
      NULL,
      ' 9- 1-1979',
      57.211362,
      91.099629,
      95,
      96,
      92.633089,
      101.641749,
      51.539396,
      89,
      28.998382,
      107,
      55,
      36,
      ' 1-27-1990',
      26,
      29,
      31.775701,
      30.310291,
      NULL,
      33.122336,
      8,
      ' 2-22-1990',
      18,
      NULL,
      NULL,
      3,
      3,
      4,
      11,
      15,
      7,
      NULL,
      5.686508,
      0.376771,
      46.429629,
      1.712682,
      3.966917,
      9,
      22,
      NULL,
      3.806236,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75,
      11.258534,
      ' 1-14-1984',
      NULL,
      NULL,
      NULL,
      5,
      ' 6- 9-1991',
      23,
      NULL,
      8.765981,
      NULL,
      ' 8- 1-1984',
      NULL,
      20,
      ' 9- 9-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      ' 7- 7-2001',
      18,
      55.610199,
      21,
      ' 7-17-1985',
      0,
      NULL,
      ' 0- 8-1984',
      11,
      12.267342,
      8,
      8,
      ' 4-17-2002',
      62,
      0.513435,
      140.143149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


