set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '3',
      '2',
      '2',
      '3',
      '1',
      '3',
      '4',
      '3',
      '2',
      '0',
      '1',
      NULL,
      '3',
      '1',
      '4',
      '0',
      '4',
      '3',
      NULL,
      '1',
      '1',
      '3',
      '',
      '1',
      '',
      '4',
      '0',
      '4',
      '3',
      '2',
      '',
      '',
      NULL,
      NULL,
      '2',
      '1',
      '1',
      '2',
      '2',
      '2',
      '2',
      '0',
      '0',
      NULL,
      '34240231',
      7,
      26.857865,
      '1244124',
      1,
      264.176433,
      2,
      NULL,
      '004230',
      5.677857,
      '10- 0-1974',
      NULL,
      9,
      108.074938,
      20.126886,
      16.701075,
      NULL,
      5,
      22,
      23.726270,
      29,
      23,
      NULL,
      4.475091,
      28,
      NULL,
      19.335856,
      NULL,
      14.376352,
      3,
      25.292641,
      8.234737,
      NULL,
      6.207531,
      101.016481,
      NULL,
      0,
      67,
      NULL,
      64.198610,
      NULL,
      233,
      127,
      NULL,
      52.394120,
      56,
      NULL,
      10.898146,
      65,
      150,
      ' 8- 6-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      101.645813,
      NULL,
      0.700092,
      5,
      2.557517,
      3,
      ' 1- 8-1977',
      0.291466,
      NULL,
      225.538345,
      0.242052,
      1.363329,
      168.570951,
      NULL,
      1.777775,
      35.676299,
      NULL,
      NULL,
      NULL,
      ' 7-25-2000',
      35,
      22.243088,
      17,
      45,
      81.551751,
      NULL,
      104.829156,
      31,
      58,
      NULL,
      3,
      33,
      ' 1-25-1997',
      24,
      NULL,
      13,
      NULL,
      33,
      NULL,
      10,
      NULL,
      14.256747,
      14,
      ' 8-22-1985',
      2,
      0,
      3.579670,
      8,
      7,
      0.074241,
      1.497618,
      4.312194,
      0,
      4.511108,
      1,
      NULL,
      10.136102,
      13,
      5.394379,
      6,
      0,
      0,
      ' 8- 1-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      22.516066,
      6,
      ' 9-26-1982',
      NULL,
      NULL,
      NULL,
      55,
      ' 3-28-1988',
      24.160275,
      ' 0-27-1994',
      3,
      1,
      ' 5-28-1982',
      20,
      91,
      ' 6-25-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      5.085968,
      ' 5-24-1999',
      28,
      66.146676,
      43,
      NULL,
      1,
      64.953233,
      ' 2-24-1985',
      12,
      NULL,
      NULL,
      22.510610,
      ' 0-25-1979',
      68,
      0,
      99,
      ' 7-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


