set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8726488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '0',
      NULL,
      '3',
      '3',
      NULL,
      '0',
      NULL,
      '2',
      NULL,
      '3',
      '2',
      '1',
      '4',
      '0',
      '4',
      '1',
      '2',
      '0',
      '4',
      '3',
      '4',
      '4',
      NULL,
      '2',
      '',
      '2',
      '4',
      '4',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '3',
      NULL,
      '1',
      '4',
      '2',
      '3',
      NULL,
      '2',
      '2',
      '4',
      '340',
      '10104030',
      55,
      39,
      '0440222',
      3.634986,
      NULL,
      1,
      NULL,
      '314402',
      0.275423,
      NULL,
      ' 4-27-1980',
      23,
      NULL,
      17,
      NULL,
      8,
      5.933349,
      70.270191,
      NULL,
      12.171713,
      14.649546,
      6.087052,
      15,
      37.263671,
      8.777217,
      34.469104,
      1,
      NULL,
      31.712674,
      66.011899,
      6,
      43.124449,
      NULL,
      NULL,
      13,
      0,
      54.691851,
      30.173144,
      123,
      39.866241,
      NULL,
      48.897235,
      NULL,
      44,
      NULL,
      9.037166,
      NULL,
      NULL,
      118,
      ' 7- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.598282,
      16.822546,
      4,
      13.469461,
      9.124877,
      0,
      ' 1-25-1977',
      0,
      1,
      122,
      1.920025,
      1,
      37.651150,
      0.147835,
      1,
      29,
      NULL,
      NULL,
      NULL,
      '10-20-1977',
      12,
      62,
      26.562059,
      25,
      NULL,
      38,
      NULL,
      38.869125,
      56,
      76,
      NULL,
      15.864057,
      ' 6-10-1989',
      5,
      17,
      6.940940,
      33,
      40,
      58,
      10.034115,
      ' 8- 2-1998',
      NULL,
      9,
      ' 2- 9-1987',
      11,
      4,
      17,
      NULL,
      NULL,
      4.248673,
      1.366186,
      4,
      1.065838,
      NULL,
      NULL,
      0.963333,
      9.519446,
      16.292596,
      NULL,
      7.289326,
      1,
      1,
      ' 7-27-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      300.716499,
      3.908994,
      NULL,
      NULL,
      NULL,
      NULL,
      37.890040,
      ' 4- 9-1986',
      39,
      NULL,
      9.155601,
      0,
      ' 0- 9-2003',
      4.595575,
      84.242566,
      ' 6-13-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      17.763677,
      '11-20-1984',
      25,
      45.834928,
      29.307747,
      '11-14-1982',
      1,
      24.056682,
      ' 9- 0-1991',
      NULL,
      19.611682,
      NULL,
      6,
      ' 5-12-1996',
      13.521655,
      1,
      116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


