set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8226778';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1113',
      '22213313',
      '01240222',
      '00440331',
      '33000034',
      NULL,
      NULL,
      NULL,
      '21431430',
      '12002410',
      '02424112',
      NULL,
      '03443430',
      '00243233',
      '13342204',
      '30043220',
      '34400042',
      '23324221',
      NULL,
      '43111404',
      '10434041',
      NULL,
      '02001214',
      '23314010',
      NULL,
      '44213401',
      NULL,
      NULL,
      '20332030',
      '24014300',
      '01123011',
      '31420113',
      '30413201',
      '04124344',
      NULL,
      NULL,
      '40403201',
      '04101422',
      '34041423',
      '01230222',
      NULL,
      '01132114',
      '24130243',
      '40401413',
      NULL,
      '312',
      '02',
      NULL,
      NULL,
      '2301320',
      1.059614,
      0,
      NULL,
      NULL,
      '000334',
      4,
      NULL,
      ' 8-24-1999',
      7.150775,
      NULL,
      12,
      1,
      15.352957,
      20,
      28,
      0,
      9.826730,
      15,
      26,
      NULL,
      NULL,
      NULL,
      16,
      1.004754,
      0,
      0.360226,
      29,
      3.947254,
      35,
      7.520179,
      125.833023,
      20.197043,
      3,
      24,
      104.011402,
      93.197725,
      NULL,
      194.217718,
      117,
      ' 0-12-2003',
      36.191317,
      20,
      25.978101,
      NULL,
      NULL,
      87,
      '11-28-1998',
      0.981467,
      1,
      NULL,
      0.525219,
      3.315449,
      1.709697,
      0,
      0.101985,
      1.038367,
      0,
      1,
      0.997630,
      0.920380,
      1,
      0.214130,
      0,
      0.899036,
      0,
      1,
      1.649634,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-12-1985',
      77.445815,
      5,
      0,
      NULL,
      15,
      6.940080,
      ' 2-12-1980',
      NULL,
      1.824470,
      13.447694,
      0,
      1.018228,
      164.921755,
      1.793133,
      1,
      89,
      0.954512,
      0.797070,
      NULL,
      NULL,
      84.326593,
      85,
      8,
      9,
      NULL,
      65,
      40,
      97.487527,
      12,
      54.208063,
      16.772354,
      18.488962,
      '11-10-1977',
      3.726867,
      19.044720,
      26.469355,
      NULL,
      39,
      52,
      6,
      ' 9-23-1985',
      8,
      3.972087,
      ' 6-16-1994',
      2.770538,
      7,
      23,
      8,
      0,
      2.884979,
      1,
      0,
      1,
      31.612727,
      9,
      NULL,
      11,
      24,
      0.177836,
      5,
      0.137748,
      1,
      NULL,
      2,
      3.914632,
      3,
      ' 6- 0-2003',
      73,
      13.432439,
      NULL,
      49.038317,
      10.968949,
      '11-11-1994',
      4,
      ' 9- 5-2000',
      0.764388,
      ' 2- 4-1983',
      5,
      1.673856,
      ' 1-21-1993',
      116,
      26.665038,
      NULL,
      0,
      0.764777,
      ' 6-19-1982',
      NULL,
      1.220899,
      ' 3-28-2002',
      3,
      2,
      11,
      NULL,
      6.670028,
      NULL,
      40,
      '11-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


