set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9201371';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3030',
      NULL,
      '32434403',
      '04322411',
      '23411420',
      '31143134',
      '22242040',
      '41042413',
      '41224343',
      '30344132',
      '02201430',
      '10430131',
      '02001031',
      '42140334',
      '32041232',
      '01222010',
      NULL,
      '43114023',
      '42022323',
      NULL,
      '44434122',
      '23443003',
      '20114404',
      '12100303',
      '34220114',
      '42431201',
      '13030000',
      '32134122',
      '34122444',
      '12100121',
      '32033011',
      '32020002',
      '22412303',
      NULL,
      '11314011',
      '12434220',
      '11112201',
      '44431434',
      '02401312',
      '13231220',
      '20300002',
      '22001232',
      '30301224',
      '22111111',
      '31120322',
      '140',
      '43',
      NULL,
      NULL,
      NULL,
      0.398842,
      1.527997,
      1,
      NULL,
      '324344',
      5,
      ' 4-22-1997',
      ' 5-21-1975',
      12,
      NULL,
      10,
      NULL,
      11.029146,
      7.486015,
      37.612242,
      1.622470,
      30,
      6.887856,
      4,
      28.137521,
      8,
      NULL,
      NULL,
      NULL,
      36.237997,
      NULL,
      40.185475,
      20,
      12,
      3,
      131,
      2,
      2,
      42.178897,
      79,
      NULL,
      138.826226,
      113.852668,
      NULL,
      ' 3-11-1983',
      42.637558,
      3.422338,
      30,
      10,
      19,
      45.479739,
      ' 6- 8-1983',
      1,
      7.078859,
      0.606632,
      4.420971,
      3,
      0.574967,
      3.613105,
      NULL,
      1,
      1.038431,
      4,
      0,
      0.799249,
      5.686516,
      1,
      NULL,
      NULL,
      1.222939,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-14-1978',
      102,
      14,
      1,
      9.879180,
      NULL,
      9.648548,
      ' 9-13-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.832197,
      106,
      17.896755,
      68,
      51,
      16,
      99,
      9.141432,
      NULL,
      73.383791,
      NULL,
      35,
      ' 4-20-1984',
      17,
      14,
      10,
      17,
      1,
      0.751167,
      8,
      ' 2- 5-1992',
      16.726969,
      1.546880,
      ' 7-28-1975',
      NULL,
      15.023497,
      NULL,
      22,
      22.304670,
      5,
      NULL,
      10.509471,
      1,
      NULL,
      1,
      3.942980,
      NULL,
      5,
      1.877657,
      0,
      0.505518,
      0.225197,
      ' 9- 5-1992',
      NULL,
      3.744552,
      1.495970,
      ' 9-13-1977',
      90,
      13.276257,
      ' 5- 4-2002',
      33.889222,
      11,
      NULL,
      29,
      ' 4- 5-2003',
      32,
      ' 0-15-2002',
      5,
      21.437545,
      ' 2-22-1992',
      NULL,
      NULL,
      NULL,
      6,
      3.267743,
      ' 2-27-1995',
      3.293685,
      1.593896,
      NULL,
      2,
      2,
      12,
      NULL,
      22,
      46,
      10.981310,
      ' 7-28-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8);
commit;
end;
/


