set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8528467';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3013',
      '41123001',
      '43132022',
      '43331421',
      '01402103',
      NULL,
      '01123132',
      '14012242',
      '13124101',
      '03434324',
      '13221043',
      '24210022',
      NULL,
      '20200204',
      '34431241',
      '03121103',
      '04143210',
      '04013212',
      '40230432',
      '24323411',
      '41423423',
      '21442312',
      NULL,
      NULL,
      '41010314',
      '20113241',
      '14132330',
      '00431300',
      '10300310',
      '13410310',
      '23413134',
      '13314424',
      '43432202',
      '01221222',
      NULL,
      NULL,
      '32131032',
      '03321314',
      '21141030',
      '30330230',
      '02132242',
      NULL,
      '22040014',
      '42402223',
      '31103412',
      '',
      '',
      NULL,
      NULL,
      '2303134',
      1,
      0.907376,
      NULL,
      NULL,
      '330422',
      1.101625,
      ' 3- 3-1998',
      NULL,
      51.208566,
      NULL,
      16.704377,
      8.053756,
      NULL,
      13.829952,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      20,
      NULL,
      NULL,
      18,
      16.585417,
      NULL,
      NULL,
      28.396855,
      13.395363,
      36,
      10.846197,
      91,
      17.384779,
      NULL,
      114,
      82.005610,
      61,
      113.982251,
      NULL,
      67.719808,
      ' 5-14-1997',
      NULL,
      3.044319,
      23,
      36,
      NULL,
      186.742952,
      ' 5-15-1985',
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679399,
      1.643924,
      2,
      0.453303,
      0.075680,
      1.268539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-28-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 6-1987',
      74.913791,
      117.777528,
      NULL,
      95.114221,
      91.001969,
      44,
      6.327625,
      42.107354,
      17,
      94,
      NULL,
      79.048958,
      ' 2-18-1998',
      17.607260,
      7,
      3,
      16.893222,
      11.104165,
      28,
      11,
      NULL,
      NULL,
      33.587397,
      ' 2-11-1989',
      3,
      5,
      4,
      11.333634,
      NULL,
      9,
      NULL,
      22.402188,
      NULL,
      68.694240,
      0,
      8.581400,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      28,
      43,
      ' 9- 0-1982',
      0,
      NULL,
      ' 7- 0-1989',
      16.078046,
      2.708626,
      NULL,
      6.348278,
      ' 5-18-1998',
      70,
      0,
      78.225672,
      ' 4-14-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      175.439175,
      1.462723,
      NULL,
      NULL,
      80.393909,
      57.318845,
      50.391311,
      2.312394,
      59,
      0.502355,
      NULL,
      22.579570,
      1.514313,
      45,
      NULL,
      0,
      6.869096,
      NULL,
      1,
      79,
      1.782708,
      0.544981,
      177.542307,
      NULL,
      10.188481,
      NULL,
      1,
      NULL,
      1,
      0.235985,
      0.013475,
      0,
      1,
      0.041350,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.586118,
      9,
      0,
      0.495600,
      1.329188,
      NULL,
      0,
      NULL,
      0.477855,
      NULL,
      1.712094,
      1,
      NULL,
      10,
      3.156210,
      1.331322,
      NULL,
      NULL,
      28,
      NULL,
      17,
      3.754054,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      ' 3-14-1981',
      NULL,
      ' 5-17-1998',
      ' 0- 8-1978',
      NULL,
      ' 4-27-1978',
      ' 7-22-1974',
      NULL);
commit;
end;
/


