set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2142',
      '41422300',
      '23321131',
      '21143244',
      '44412232',
      '11441020',
      '42033342',
      '13203224',
      NULL,
      NULL,
      '31434031',
      '00210211',
      '13044021',
      '41404223',
      '12021033',
      '14231222',
      '00140301',
      '41313031',
      '33023210',
      NULL,
      '44230040',
      '23214303',
      '11411121',
      '23403402',
      NULL,
      '31123100',
      NULL,
      NULL,
      '13414220',
      '14102244',
      '14411301',
      '10234221',
      '33441341',
      '02123102',
      '41303434',
      '31122334',
      NULL,
      '13331322',
      '14023234',
      '12414102',
      '24134122',
      '14241023',
      '11331131',
      '40411210',
      '11044410',
      '',
      NULL,
      NULL,
      NULL,
      '4023144',
      2.946349,
      0.370121,
      0,
      NULL,
      '203120',
      1,
      ' 8- 5-1987',
      ' 0- 1-1984',
      35.390935,
      NULL,
      NULL,
      NULL,
      0.215852,
      1,
      29.160643,
      3,
      8.424087,
      0.909610,
      24.129463,
      14.587191,
      2.736234,
      0,
      16,
      18,
      2,
      NULL,
      NULL,
      5,
      28.372982,
      5.936193,
      56,
      11.380166,
      NULL,
      15,
      126.125295,
      20,
      86.257540,
      77.324106,
      146,
      ' 2-19-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.174897,
      7,
      NULL,
      0.026932,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.316822,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-27-1987',
      35.937398,
      NULL,
      12,
      9.966947,
      11,
      104.766965,
      71,
      NULL,
      73,
      90,
      33.510076,
      62,
      NULL,
      2,
      10,
      20,
      NULL,
      62,
      NULL,
      9,
      ' 3- 5-1992',
      14,
      1.402131,
      ' 1-15-1993',
      4.070294,
      7.315700,
      1,
      1,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      56,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 2-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      23,
      24.656812,
      NULL,
      0,
      116,
      ' 8- 7-1991',
      16.497967,
      23,
      10.106976,
      NULL,
      NULL,
      39,
      1,
      129,
      ' 1-27-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      122.235755,
      17,
      73,
      49,
      8.697560,
      15.426407,
      35.119670,
      10.799124,
      37.203707,
      3.263242,
      NULL,
      3,
      1.779687,
      NULL,
      1,
      1,
      44.630723,
      0.038334,
      3.372277,
      106.884933,
      5,
      NULL,
      148,
      32.419187,
      NULL,
      NULL,
      1.948923,
      11.041383,
      0.265191,
      0.395929,
      1.781934,
      0,
      1,
      0,
      16.918786,
      34.011906,
      NULL,
      NULL,
      81.201365,
      1.155709,
      NULL,
      NULL,
      0,
      0.762404,
      0,
      0.957451,
      22.672798,
      0.064759,
      60,
      NULL,
      9,
      0.118326,
      4,
      82.798444,
      10,
      1,
      22,
      NULL,
      63,
      10.170452,
      90.382855,
      11,
      14,
      NULL,
      0.316089,
      0,
      0.104387,
      1,
      6.655567,
      20,
      ' 5-15-1984',
      NULL,
      ' 8-27-1989',
      '10-17-2000',
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


