set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0012',
      '32343032',
      '42122324',
      NULL,
      '03030042',
      '31343411',
      '34434402',
      '43430311',
      NULL,
      '00032422',
      '31042200',
      '34320110',
      '43211113',
      '23442123',
      '32441110',
      '11311301',
      '41134211',
      '10110400',
      '01440224',
      NULL,
      '30241141',
      '21330034',
      NULL,
      '31322210',
      '21244102',
      '34112332',
      '03422402',
      NULL,
      NULL,
      '01244143',
      '24213330',
      NULL,
      '12404413',
      NULL,
      '12424443',
      '00130341',
      '22021003',
      '31320122',
      '12023441',
      '01341332',
      '41041301',
      '11333413',
      '34214214',
      '03320421',
      '43430142',
      '133',
      '14',
      NULL,
      NULL,
      NULL,
      NULL,
      48.516477,
      1,
      NULL,
      '222313',
      NULL,
      NULL,
      ' 0-14-1984',
      31.935455,
      NULL,
      13,
      19.165304,
      22,
      15.742935,
      52.990764,
      7,
      NULL,
      6,
      40,
      7.381571,
      NULL,
      22.844527,
      21,
      11.185107,
      NULL,
      22,
      61,
      11,
      11.665946,
      10,
      NULL,
      11.874873,
      3,
      115.976204,
      168.406773,
      57.036322,
      17,
      32.930104,
      144,
      ' 0- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661587,
      NULL,
      1.132338,
      0.776017,
      NULL,
      0.678103,
      0.912324,
      0.392014,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.677111,
      NULL,
      0.632714,
      1.428911,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-29-1996',
      52,
      14.787221,
      7,
      NULL,
      13.731558,
      5,
      ' 6-23-2003',
      1,
      1.631988,
      81,
      NULL,
      1,
      54,
      2,
      NULL,
      94.885771,
      1.276045,
      NULL,
      131,
      NULL,
      NULL,
      127,
      NULL,
      132.431750,
      83.635156,
      51,
      NULL,
      35.443795,
      85,
      49,
      52,
      50.147326,
      ' 3-19-1998',
      9.036040,
      0,
      NULL,
      NULL,
      57.766908,
      NULL,
      0.353606,
      ' 5-26-1992',
      2.848053,
      1,
      ' 7- 9-1977',
      5.819143,
      7,
      13,
      7.110952,
      13.637351,
      6.500855,
      0.069569,
      NULL,
      0,
      NULL,
      0,
      11,
      10.643180,
      28.531983,
      0,
      0,
      1.751048,
      0,
      ' 6- 3-1999',
      2.858239,
      1.284736,
      5.510489,
      ' 2- 9-1975',
      162.888935,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      41.552023,
      '10-19-1979',
      38,
      NULL,
      14,
      0,
      ' 2-28-1986',
      65,
      111.581884,
      ' 0-29-2000',
      NULL,
      6,
      ' 4-17-1990',
      1.318142,
      6,
      ' 1- 7-1990',
      2,
      NULL,
      20.275357,
      '11-18-1989',
      63,
      NULL,
      34,
      ' 1- 2-1990',
      1.158427,
      20.693882,
      ' 2-19-1981',
      17,
      3.320540,
      NULL,
      118,
      ' 9-22-1985',
      NULL,
      1.208783,
      102.426202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


