set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12333101',
      NULL,
      '23034110',
      '00422404',
      '01342023',
      '12300203',
      '14201140',
      '13110244',
      NULL,
      '11134202',
      '14101431',
      '20010221',
      '42104122',
      '30320012',
      '40010022',
      NULL,
      '44243410',
      NULL,
      NULL,
      '43112212',
      '13101330',
      '40131014',
      '41114341',
      '02202134',
      '34344141',
      NULL,
      '32413143',
      '32422144',
      '40223203',
      NULL,
      '31110222',
      NULL,
      '02431444',
      '43443103',
      '14431442',
      '10331131',
      '20214204',
      '12212123',
      '14033102',
      '42321431',
      '13114111',
      '32222002',
      '40310100',
      '41104000',
      '411',
      '04',
      NULL,
      NULL,
      '2201330',
      0.045785,
      101,
      1,
      NULL,
      '433100',
      2,
      '10-28-1990',
      ' 4- 8-1991',
      NULL,
      NULL,
      NULL,
      0.671547,
      16.697006,
      7,
      37.907162,
      16.513210,
      8,
      NULL,
      19,
      4.015173,
      19.394079,
      0,
      22,
      13,
      14.930243,
      13,
      59.941383,
      20,
      29.566199,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      5.501626,
      29,
      189.181822,
      NULL,
      36,
      ' 6-27-2001',
      63.299124,
      NULL,
      33.936652,
      4,
      NULL,
      185.666271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      17.282293,
      NULL,
      10,
      7,
      NULL,
      0.955059,
      1,
      NULL,
      0,
      NULL,
      12,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 7-1975',
      11,
      31,
      21.783242,
      NULL,
      35.426092,
      54,
      NULL,
      73.007315,
      NULL,
      26,
      27,
      19.234287,
      ' 9-18-1997',
      NULL,
      10.782093,
      6,
      72,
      62.211270,
      NULL,
      9.792941,
      ' 3- 6-1991',
      7.744833,
      9.338803,
      NULL,
      10.068250,
      15.426586,
      4,
      NULL,
      6.089311,
      2,
      1,
      6,
      3.293037,
      NULL,
      NULL,
      3.225431,
      11.340942,
      26.672930,
      3,
      4,
      3.030578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      106,
      6.652814,
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      NULL,
      16.754385,
      ' 9-19-1974',
      11,
      NULL,
      ' 8-12-1987',
      NULL,
      28,
      ' 3-20-1991',
      7.524083,
      2.110406,
      ' 1-21-1982',
      NULL,
      NULL,
      NULL,
      2,
      0,
      5.683685,
      '10-21-1976',
      NULL,
      NULL,
      12.299909,
      NULL,
      NULL,
      143.297833,
      ' 5-12-1977',
      10.892403,
      44,
      0,
      76,
      ' 4- 5-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


