set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '2',
      '4',
      '3',
      '4',
      NULL,
      '0',
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '2',
      NULL,
      '2',
      '2',
      '2',
      NULL,
      '4',
      '2',
      '2',
      '3',
      '3',
      '',
      '3',
      '',
      '1',
      '0',
      '0',
      NULL,
      '3',
      '',
      '',
      '0',
      '3',
      '3',
      '4',
      '2',
      '4',
      '1',
      '4',
      '2',
      NULL,
      '3',
      NULL,
      '42432200',
      NULL,
      40.044358,
      '0244313',
      NULL,
      152.897058,
      0,
      NULL,
      NULL,
      1.828766,
      ' 0-19-1979',
      ' 6- 8-1982',
      4,
      NULL,
      NULL,
      7,
      4.175082,
      2.043056,
      91,
      17.195130,
      12,
      15,
      0.242368,
      NULL,
      30.776704,
      8.169941,
      NULL,
      12,
      0.460238,
      NULL,
      NULL,
      4,
      62.938107,
      4,
      73,
      11.352949,
      NULL,
      NULL,
      133,
      30,
      174.873169,
      158,
      97,
      ' 6-17-1982',
      29,
      12,
      19,
      19,
      NULL,
      68.589200,
      ' 4- 1-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      92,
      33,
      9,
      7,
      7,
      0,
      ' 9-22-1999',
      NULL,
      0,
      27,
      1,
      3,
      108,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-17-1976',
      37,
      31,
      58,
      36,
      38.173094,
      21.094096,
      77,
      8.292180,
      61.847750,
      NULL,
      NULL,
      18,
      ' 1- 6-1977',
      2,
      22.115136,
      NULL,
      48,
      16.180551,
      22,
      8.168792,
      NULL,
      6,
      0,
      '11-22-2003',
      9.895939,
      5,
      4.848259,
      6,
      12.680227,
      6.310203,
      3.028141,
      14.402595,
      1.492736,
      8.677606,
      NULL,
      NULL,
      16.915699,
      4.030331,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      172,
      1.258802,
      ' 3- 5-1988',
      NULL,
      NULL,
      NULL,
      33,
      ' 2-12-1991',
      NULL,
      ' 4-12-1978',
      15.503920,
      0.718463,
      ' 4- 1-1995',
      100,
      45,
      ' 9-13-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      63.200982,
      29,
      2,
      ' 2-25-2003',
      0.216032,
      44,
      '11-24-1996',
      0,
      NULL,
      NULL,
      92,
      ' 4- 1-2003',
      51.558725,
      1,
      248.325763,
      ' 3- 6-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


