set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8930175';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '0',
      '4',
      '1',
      NULL,
      '0',
      '1',
      '4',
      '2',
      '1',
      '2',
      '3',
      '1',
      '1',
      NULL,
      '2',
      '1',
      '1',
      '1',
      '0',
      '4',
      '3',
      NULL,
      '',
      '1',
      '',
      '4',
      '0',
      NULL,
      NULL,
      '4',
      '',
      '',
      NULL,
      '3',
      '2',
      '2',
      '0',
      '2',
      '3',
      '4',
      '4',
      '0',
      '3',
      '001',
      '31122011',
      45,
      20,
      NULL,
      2,
      231,
      0,
      1,
      '020413',
      5.932137,
      ' 0- 6-1977',
      ' 0- 8-1991',
      83,
      95,
      21.402039,
      12.531895,
      17,
      13,
      NULL,
      8,
      13,
      1.857195,
      NULL,
      15.415197,
      52.455952,
      33.756928,
      26,
      12.154248,
      22.815423,
      0.293774,
      29,
      30,
      64,
      7,
      NULL,
      11,
      3,
      4.247936,
      NULL,
      50.850736,
      27,
      153,
      NULL,
      ' 0-23-1986',
      25.954355,
      28,
      18,
      NULL,
      NULL,
      187,
      ' 7-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.335471,
      28.159918,
      14,
      17,
      3.706035,
      '11-19-1975',
      0.816829,
      1.126544,
      NULL,
      NULL,
      0.594360,
      81,
      1,
      0.791491,
      82,
      NULL,
      NULL,
      NULL,
      ' 9-26-1981',
      NULL,
      45,
      NULL,
      59,
      6.021465,
      62,
      94.694711,
      37.988186,
      83,
      NULL,
      55.833393,
      47.325480,
      ' 7-14-1979',
      NULL,
      6,
      NULL,
      40.535887,
      28,
      17,
      4,
      ' 5-24-1981',
      NULL,
      13,
      ' 1-20-1988',
      4,
      2.850804,
      6.741334,
      10,
      7,
      4,
      NULL,
      NULL,
      1.977174,
      58,
      2.172283,
      NULL,
      9.967314,
      24.614005,
      1,
      1.740484,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      136,
      6.146431,
      ' 3-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.168830,
      ' 2-26-1985',
      8,
      NULL,
      ' 8-26-1981',
      47.065498,
      62.056966,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      9.243077,
      ' 1-29-1994',
      NULL,
      16.770651,
      37,
      ' 9-11-2000',
      0,
      7.199626,
      '10-18-1986',
      0,
      43,
      13,
      2.198514,
      NULL,
      66.052779,
      0.775357,
      143,
      ' 5-17-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


