set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3030',
      '34333110',
      '10134220',
      '40433103',
      '31243021',
      '13312020',
      '32134221',
      '23111044',
      '42222011',
      '21131324',
      '41434340',
      NULL,
      '43110400',
      '01022203',
      '20310143',
      '34414212',
      '21133334',
      '03104134',
      '22422212',
      '40004040',
      NULL,
      '33420423',
      '13243323',
      '30121210',
      '44332233',
      '14240321',
      '01422404',
      '32321304',
      '20033022',
      NULL,
      '14444100',
      '22423014',
      '40012303',
      NULL,
      '10413103',
      '13041002',
      '33332442',
      NULL,
      '41030032',
      '11134001',
      '11230331',
      '21340040',
      '01112343',
      '33204341',
      NULL,
      NULL,
      '23',
      NULL,
      NULL,
      '2423342',
      1.338850,
      0.380650,
      3,
      NULL,
      '422403',
      NULL,
      ' 7-14-1988',
      ' 1-22-1983',
      26.205743,
      NULL,
      NULL,
      8,
      19.389204,
      NULL,
      0.258316,
      8,
      6,
      1.099415,
      32.970976,
      9,
      NULL,
      14.219677,
      18,
      6,
      10,
      8.258670,
      33.120672,
      4,
      54.312012,
      17,
      45.543368,
      14,
      1.487132,
      76,
      128,
      3.196490,
      NULL,
      NULL,
      NULL,
      '10- 9-1983',
      8,
      29.143078,
      36,
      20,
      152,
      174.246975,
      '10-20-1975',
      1,
      3.467396,
      NULL,
      0,
      1,
      0,
      0.822440,
      4,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      5.875443,
      NULL,
      0,
      5.982889,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-26-1992',
      11,
      51,
      4,
      19,
      3.709177,
      1.637820,
      '10- 2-1984',
      NULL,
      1,
      94,
      0,
      NULL,
      73,
      3,
      0.873853,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      60,
      NULL,
      90,
      102.401134,
      97.356867,
      NULL,
      25.421680,
      61.537655,
      52,
      83.219362,
      ' 6-16-1993',
      NULL,
      14.491635,
      15,
      34,
      73,
      74,
      11,
      ' 2- 4-1998',
      16.257416,
      NULL,
      NULL,
      7,
      13.310525,
      1,
      4.193813,
      18.677253,
      2,
      NULL,
      NULL,
      0.684079,
      NULL,
      13.033945,
      NULL,
      3,
      5.089153,
      0,
      1,
      NULL,
      0.264891,
      ' 7- 1-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      6.464830,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      ' 4-25-1982',
      28,
      ' 3-20-2000',
      14,
      NULL,
      ' 5-12-1974',
      121.791597,
      44.861094,
      '10- 6-1999',
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      9,
      '10- 3-1984',
      36,
      11.289136,
      8,
      NULL,
      0.595694,
      66.873397,
      '11- 2-1982',
      15.306244,
      31,
      6.331712,
      21,
      ' 9- 6-1989',
      5.668504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


