set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2132',
      '33233344',
      NULL,
      '01220323',
      NULL,
      '22012444',
      NULL,
      '04044040',
      '30004411',
      NULL,
      '24232240',
      NULL,
      '13141231',
      '10242433',
      '44032130',
      '30141111',
      '20303221',
      '04042022',
      '02022212',
      '00134212',
      '33243442',
      '42422102',
      '12001011',
      '03243024',
      '30041013',
      '41140432',
      '13341043',
      '10033203',
      '04012401',
      '22412033',
      '22321241',
      NULL,
      '04311323',
      '12411034',
      '41240400',
      '21014122',
      NULL,
      '12001002',
      '30123311',
      NULL,
      '04143112',
      '32131303',
      '11241104',
      NULL,
      '31132033',
      '331',
      '22',
      NULL,
      10.340163,
      '1003222',
      2,
      49,
      NULL,
      NULL,
      '223204',
      5,
      NULL,
      '10- 1-1989',
      127.196745,
      73.550746,
      1,
      22,
      NULL,
      NULL,
      38.997663,
      3,
      NULL,
      19.584088,
      NULL,
      7,
      NULL,
      NULL,
      13,
      6,
      2.538356,
      15,
      NULL,
      13.565432,
      9,
      9.965463,
      23,
      2.509698,
      1,
      NULL,
      NULL,
      34,
      73,
      111,
      NULL,
      NULL,
      37,
      8.403895,
      6,
      1.389920,
      170,
      152,
      ' 2- 7-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54.206995,
      22,
      8,
      20,
      7,
      9.056694,
      NULL,
      1,
      1,
      63,
      0.988056,
      4,
      20,
      NULL,
      0.026458,
      29.028664,
      NULL,
      NULL,
      NULL,
      ' 1-12-1997',
      45,
      48,
      NULL,
      68,
      66.928335,
      87.051116,
      NULL,
      NULL,
      NULL,
      59.612012,
      78.733734,
      45,
      ' 6- 8-1999',
      15.695408,
      NULL,
      13,
      50,
      60.154454,
      126.230889,
      9,
      ' 0- 7-1974',
      NULL,
      9.193848,
      ' 0-19-1989',
      13.018285,
      0.117218,
      15.184481,
      24.145202,
      21.608950,
      0.562493,
      0,
      24.811497,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476903,
      1.061236,
      1.735675,
      ' 0- 4-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      120,
      2.116628,
      ' 2- 2-1977',
      NULL,
      NULL,
      NULL,
      23.906892,
      NULL,
      0,
      ' 3-28-1999',
      11.271153,
      1,
      NULL,
      21,
      46,
      ' 5-29-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      9.049800,
      NULL,
      3,
      1,
      4,
      '11- 7-1989',
      0.460866,
      61,
      ' 4- 6-1995',
      1.482645,
      32,
      9,
      5,
      NULL,
      30,
      1.716771,
      23,
      '10-25-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


