set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '2',
      '2',
      '1',
      '3',
      '0',
      '1',
      NULL,
      '0',
      NULL,
      NULL,
      '0',
      '2',
      '3',
      '4',
      '2',
      '4',
      '3',
      NULL,
      '2',
      NULL,
      '1',
      '1',
      NULL,
      '',
      '1',
      '',
      '0',
      '3',
      NULL,
      '4',
      '0',
      NULL,
      '',
      '2',
      '1',
      '1',
      '4',
      '4',
      '3',
      '3',
      '3',
      '1',
      NULL,
      '4',
      NULL,
      NULL,
      19.498753,
      46,
      '1234324',
      0.560732,
      86.762141,
      2,
      NULL,
      '321131',
      5,
      ' 4-29-1981',
      '11-28-1979',
      190.804601,
      60.693410,
      40,
      NULL,
      6,
      0,
      39,
      7,
      7,
      25,
      17,
      1,
      24,
      15.628056,
      NULL,
      9.387631,
      4,
      4.662566,
      0.769064,
      15,
      14,
      15,
      NULL,
      0.194273,
      1,
      NULL,
      6,
      NULL,
      10,
      183.625946,
      18,
      ' 5- 8-1977',
      13,
      55.219190,
      11,
      13.679477,
      95,
      NULL,
      ' 0- 3-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67.568249,
      NULL,
      13,
      7.118428,
      11,
      5.772787,
      ' 0-23-1977',
      0.420728,
      0,
      58,
      1,
      1,
      82.345542,
      3.973455,
      1,
      5.306617,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1991',
      27,
      35,
      18,
      78.798846,
      15.546969,
      70.169040,
      99,
      96,
      70,
      92.625060,
      47,
      3,
      '10- 7-1978',
      12.537286,
      18.825408,
      5.708095,
      68.085599,
      NULL,
      NULL,
      11.363836,
      ' 5-26-2001',
      NULL,
      NULL,
      ' 4-28-1981',
      18,
      1,
      NULL,
      23.056417,
      16.599290,
      NULL,
      1,
      15,
      0.964886,
      57.671747,
      NULL,
      6,
      21,
      22,
      1,
      0.540440,
      1,
      1,
      ' 6-20-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      89,
      14,
      ' 4-14-1984',
      NULL,
      NULL,
      NULL,
      6.191382,
      ' 6- 1-1977',
      NULL,
      ' 3-21-1995',
      2.377267,
      2.178350,
      ' 1-25-1976',
      110.539723,
      NULL,
      '11-29-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      ' 4- 6-1993',
      61,
      12.688096,
      7,
      '11- 4-2003',
      NULL,
      10.116317,
      ' 6-16-2001',
      NULL,
      26.683814,
      0.131236,
      28.728717,
      '11-17-1975',
      34.209069,
      1.879555,
      NULL,
      ' 4-29-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


