set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8404232';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3113',
      '44410321',
      '12002413',
      '03030421',
      '33444444',
      '20420102',
      '10031203',
      '41210242',
      '11314121',
      '10104424',
      '13313300',
      '12403412',
      '04003233',
      '41003444',
      '13000033',
      '01402211',
      '14402214',
      '32040221',
      '11210034',
      '01433300',
      '13114222',
      NULL,
      '13312040',
      '23433031',
      '20141101',
      '43200332',
      '00344313',
      '11044122',
      NULL,
      '13100340',
      '41103322',
      '13401233',
      '20044413',
      '43302140',
      '12201331',
      NULL,
      NULL,
      '24433230',
      '33341021',
      '04331340',
      '32241303',
      '30013024',
      '40301034',
      '00024022',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0402313',
      2,
      1,
      NULL,
      NULL,
      '014302',
      3,
      ' 3- 0-1990',
      ' 7-15-1986',
      23.852608,
      NULL,
      9,
      NULL,
      18.083638,
      0.630543,
      NULL,
      NULL,
      NULL,
      27,
      52,
      29,
      22,
      8,
      NULL,
      19.305137,
      8.414690,
      24,
      57.771464,
      25.248463,
      4.426977,
      13.590248,
      111,
      10,
      NULL,
      132,
      153,
      79,
      NULL,
      109,
      64,
      ' 8-10-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.155539,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375568,
      0,
      1.778623,
      1,
      1.328514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 2-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-19-1989',
      NULL,
      23,
      34,
      21.773768,
      17,
      72.182021,
      NULL,
      37,
      NULL,
      27,
      25,
      NULL,
      ' 6- 0-1987',
      28.055818,
      18.464155,
      NULL,
      50.305875,
      12.204041,
      109,
      8.214723,
      ' 2- 7-1980',
      17,
      11,
      NULL,
      4.520449,
      1.002609,
      7.393999,
      4.112321,
      17,
      8,
      NULL,
      NULL,
      NULL,
      61,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      65,
      37.642484,
      NULL,
      NULL,
      1,
      67,
      ' 5-25-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906608,
      0,
      NULL,
      63.087488,
      56,
      10.562041,
      3,
      11.113568,
      NULL,
      5,
      24.792356,
      0.828325,
      0,
      72.622939,
      0,
      2.418504,
      NULL,
      1,
      5.405660,
      111,
      NULL,
      1,
      128.818332,
      74,
      33.494480,
      0,
      0,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61,
      NULL,
      NULL,
      NULL,
      44.334563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548032,
      34.116531,
      0.225179,
      NULL,
      50.629473,
      18.362421,
      12.805841,
      NULL,
      9.052289,
      NULL,
      NULL,
      NULL,
      3,
      2.084619,
      0.348755,
      3,
      0.404740,
      0.444698,
      1,
      1.835145,
      24,
      NULL,
      '11-14-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-17-1990',
      NULL);
commit;
end;
/


