set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611946';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1440',
      '00444221',
      '24332034',
      '20030031',
      '13030222',
      '20034014',
      '33243243',
      '11123014',
      NULL,
      '43103102',
      '33310101',
      '01222221',
      NULL,
      '10210333',
      '30040322',
      NULL,
      '41344341',
      '41004030',
      '24131230',
      '30134232',
      '10332000',
      '24311113',
      '14212120',
      NULL,
      '13022124',
      '00433033',
      '10421242',
      '42232311',
      '43341022',
      '41401302',
      NULL,
      '02121203',
      '00042314',
      '20402433',
      '00013110',
      '42430010',
      '40032132',
      '30324021',
      NULL,
      NULL,
      '23442233',
      NULL,
      '31204213',
      NULL,
      '10341031',
      NULL,
      '03',
      3,
      4,
      '0020413',
      NULL,
      0,
      1,
      NULL,
      '410422',
      3.071027,
      NULL,
      NULL,
      117.015235,
      NULL,
      NULL,
      25.150001,
      19.659552,
      6.309092,
      NULL,
      9.546197,
      12,
      20,
      NULL,
      NULL,
      17.275649,
      NULL,
      10,
      16,
      13.292400,
      12.271842,
      37.499718,
      13,
      31,
      5.135271,
      57.796835,
      7.108705,
      NULL,
      12.841278,
      176,
      39.840716,
      59.163726,
      NULL,
      134,
      '10-18-1985',
      38,
      56.594476,
      7,
      0,
      168,
      169,
      ' 1- 5-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      62.875416,
      15.015404,
      NULL,
      11.859249,
      10,
      7,
      ' 5-11-1986',
      2.014995,
      3.738546,
      3,
      0,
      0.434792,
      36,
      NULL,
      3,
      51,
      NULL,
      NULL,
      NULL,
      ' 0-25-1982',
      7.186132,
      12.168094,
      74.400683,
      82.760322,
      0,
      54.680629,
      6,
      48,
      81.939260,
      66,
      65,
      70,
      ' 2-12-1989',
      42,
      NULL,
      2,
      102.777352,
      36,
      NULL,
      0.339860,
      NULL,
      2.474864,
      2,
      ' 0-27-2001',
      NULL,
      14,
      19,
      1,
      10,
      8.535416,
      NULL,
      9,
      NULL,
      32,
      3,
      9.686366,
      16.599206,
      29,
      1,
      2.564146,
      1,
      NULL,
      ' 7- 4-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      71,
      26.070544,
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      ' 1-10-1986',
      31,
      ' 9-17-1984',
      NULL,
      12.008082,
      ' 9-28-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      13.659909,
      ' 1- 6-1982',
      10.014478,
      1,
      29.028100,
      ' 5- 6-2000',
      NULL,
      69.558747,
      ' 8-17-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


