set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9522082';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3434',
      NULL,
      NULL,
      '44333010',
      '42432223',
      '40042444',
      '33040422',
      '43433210',
      '04240124',
      '24140013',
      '04200421',
      '21034312',
      '32101334',
      NULL,
      '33413032',
      '11123321',
      NULL,
      '02220223',
      '04140342',
      '11141210',
      '30434021',
      '03402441',
      '20124022',
      '23101232',
      '04042434',
      '01403131',
      '33111400',
      '23243312',
      '14201320',
      '02333230',
      '43204410',
      '10022024',
      '32214234',
      '01403221',
      '32044413',
      '21113040',
      '14120402',
      '32042311',
      '31212043',
      '40442234',
      NULL,
      '43433102',
      '24243144',
      '14013130',
      NULL,
      '341',
      NULL,
      NULL,
      NULL,
      '1111321',
      3,
      1,
      2,
      NULL,
      '300144',
      0.988802,
      ' 4-20-1981',
      ' 2- 4-1982',
      133.981888,
      NULL,
      33.729234,
      14.548203,
      22,
      16,
      90.240799,
      15,
      15.704461,
      5,
      27.567272,
      2,
      NULL,
      4,
      7.585479,
      0,
      NULL,
      12.188430,
      NULL,
      15.312555,
      16.583783,
      NULL,
      72,
      15.513492,
      1.991746,
      NULL,
      17.370459,
      NULL,
      88.370939,
      136,
      NULL,
      ' 8-13-2000',
      52,
      27,
      20,
      NULL,
      NULL,
      33,
      ' 9-28-1988',
      NULL,
      1,
      4,
      0.640584,
      2,
      NULL,
      0.914293,
      0,
      NULL,
      NULL,
      3.674825,
      1.393684,
      0,
      1.767887,
      0.347513,
      0.222763,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-27-1976',
      78.608303,
      NULL,
      9,
      10.362124,
      9,
      0.826731,
      ' 9- 7-1988',
      0,
      1,
      12.049870,
      0,
      0.516897,
      NULL,
      2,
      3.398399,
      74.039116,
      NULL,
      NULL,
      NULL,
      ' 4-16-1991',
      NULL,
      106,
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      84.307921,
      93,
      18,
      62.717918,
      115,
      NULL,
      27,
      NULL,
      21.922235,
      NULL,
      66.475642,
      NULL,
      2,
      NULL,
      11,
      5.076591,
      ' 2-19-1988',
      9,
      8.125379,
      5,
      0,
      2.838283,
      5.992481,
      1.978663,
      13,
      1,
      52,
      0.727087,
      3.634042,
      0,
      3,
      5,
      1.273477,
      NULL,
      0.613698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      ' 2-19-1995',
      26.796403,
      ' 8-11-1998',
      15.330469,
      16,
      ' 9-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      25,
      ' 0-21-1994',
      NULL,
      NULL,
      0.238265,
      NULL,
      NULL,
      7.935691,
      ' 6-29-1991',
      3.268176,
      28,
      NULL,
      NULL,
      ' 9-12-1978',
      28.948610,
      NULL,
      99,
      '10-25-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


