set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7714376';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '2',
      '3',
      '0',
      '4',
      '4',
      NULL,
      '1',
      '4',
      '2',
      NULL,
      '0',
      '1',
      '0',
      NULL,
      '1',
      '3',
      '1',
      '4',
      '3',
      NULL,
      '3',
      '2',
      '',
      '3',
      '',
      '3',
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      '',
      '1',
      '1',
      '4',
      '0',
      '1',
      '4',
      NULL,
      '0',
      '2',
      '4',
      '3',
      '434',
      '31021202',
      NULL,
      40.966062,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '422301',
      4,
      ' 1-26-2003',
      '10-27-1981',
      7.304785,
      76,
      19.893273,
      17.779028,
      9,
      NULL,
      42,
      19.693723,
      9.327847,
      9,
      NULL,
      14,
      10,
      8,
      NULL,
      1.232450,
      20,
      17.208495,
      9.553796,
      27,
      26.513562,
      16,
      49.545417,
      4.217778,
      0,
      98,
      NULL,
      NULL,
      6,
      92.316592,
      132,
      ' 3-21-1979',
      50,
      9.283062,
      NULL,
      30.672015,
      NULL,
      137.930442,
      ' 9-21-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      4,
      1.297781,
      NULL,
      9,
      5.374825,
      '10-15-1976',
      1.776046,
      1,
      28,
      1,
      1.256473,
      NULL,
      0.306004,
      NULL,
      4.906197,
      NULL,
      NULL,
      NULL,
      ' 5-11-1974',
      NULL,
      0.422657,
      44.798547,
      44,
      NULL,
      62,
      NULL,
      0,
      53,
      37,
      57,
      5,
      ' 9-21-1995',
      11,
      6,
      10,
      47,
      11,
      32.496883,
      4,
      ' 0- 3-2002',
      1.540507,
      18.425893,
      '10-18-1979',
      NULL,
      17.662564,
      17,
      10.227607,
      27,
      12.554333,
      0.661726,
      29.803122,
      0,
      30.348071,
      1.348581,
      1.372542,
      8.612650,
      28.405099,
      0,
      0.070674,
      1,
      NULL,
      ' 0-25-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      224,
      NULL,
      ' 0-21-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.303189,
      ' 7-17-1980',
      21.569130,
      9,
      ' 2-16-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      14.969552,
      '11- 9-1986',
      52,
      NULL,
      NULL,
      NULL,
      1,
      8,
      '10-23-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


