set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8009266';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0232',
      NULL,
      '23122334',
      '43223443',
      '43110424',
      '14343443',
      '41421332',
      '13131214',
      '33424021',
      NULL,
      '20414133',
      NULL,
      '23202433',
      '32000124',
      '22344220',
      '24221143',
      '21304130',
      '31340034',
      '33334234',
      '13312342',
      '21311334',
      NULL,
      '33014414',
      NULL,
      '42204042',
      '03130430',
      NULL,
      '13412412',
      '30102212',
      '43322444',
      '20024021',
      '00440222',
      '10041022',
      '44401413',
      '20422424',
      '04313424',
      '12221433',
      '12314434',
      '30340420',
      '40241042',
      '02410402',
      '02104221',
      '42110422',
      '43044043',
      '00123444',
      '',
      '',
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      ' 1-26-1996',
      NULL,
      45.853300,
      NULL,
      37,
      14.370801,
      NULL,
      8.873437,
      84.320799,
      NULL,
      5.735105,
      NULL,
      5.704889,
      NULL,
      17.393305,
      NULL,
      6.464634,
      29.936157,
      NULL,
      21,
      83,
      2,
      33,
      11,
      65,
      24,
      NULL,
      22.894804,
      194.796915,
      85,
      81.958549,
      NULL,
      NULL,
      '10-20-2003',
      NULL,
      35,
      17.256306,
      30.681319,
      NULL,
      125,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.716407,
      0.746723,
      NULL,
      1.008309,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1994',
      22.643466,
      103,
      71.144201,
      114,
      116,
      78.283054,
      NULL,
      54.705535,
      NULL,
      11,
      76,
      NULL,
      ' 7- 1-1975',
      3,
      0,
      22.663773,
      NULL,
      3.350655,
      140.527637,
      2,
      NULL,
      NULL,
      4.311538,
      ' 2- 1-1988',
      3.290866,
      8.316937,
      5.989662,
      3,
      NULL,
      11.482675,
      NULL,
      6,
      NULL,
      21.438032,
      4.733045,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-26-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      NULL,
      41.911741,
      ' 6- 1-1981',
      1,
      47.388323,
      ' 3- 8-1980',
      2.049680,
      25,
      NULL,
      NULL,
      ' 1-15-1985',
      26,
      NULL,
      98,
      ' 1- 7-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.291496,
      3.066024,
      4.474262,
      4,
      NULL,
      NULL,
      0.879947,
      6.872044,
      23,
      1.927550,
      5,
      58,
      3.183974,
      0.072228,
      NULL,
      0.600497,
      1.779813,
      143.256333,
      NULL,
      25.957797,
      NULL,
      1.884256,
      NULL,
      1.932313,
      NULL,
      1,
      0,
      1.951467,
      1.362577,
      NULL,
      NULL,
      NULL,
      11.083293,
      NULL,
      NULL,
      NULL,
      6.070335,
      49,
      1,
      NULL,
      NULL,
      19.952453,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      29.933493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      ' 7- 2-1980',
      '10-13-1983',
      ' 2- 4-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


