set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8612598';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3404',
      '22432111',
      '44233423',
      NULL,
      '43021203',
      '13443224',
      '42441241',
      '14323204',
      '31414004',
      '23342223',
      '03020021',
      '00430412',
      NULL,
      '41013041',
      '22111123',
      '23323221',
      NULL,
      NULL,
      '32221023',
      '41434214',
      '22104304',
      NULL,
      '43201220',
      NULL,
      NULL,
      '01403302',
      NULL,
      '30004113',
      '02314343',
      '04434012',
      '04020322',
      NULL,
      '31133131',
      '00233332',
      '42320003',
      '43233131',
      '42234201',
      '32001003',
      '12142121',
      '30432044',
      '23400031',
      '32322322',
      '33231333',
      '42320120',
      '00214440',
      '020',
      '43',
      NULL,
      NULL,
      NULL,
      2,
      0.522904,
      2,
      NULL,
      '323111',
      4,
      '10-15-1991',
      ' 7- 3-1984',
      2.828329,
      NULL,
      NULL,
      NULL,
      13,
      6.312842,
      14,
      NULL,
      4.206658,
      2.315949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      25,
      9.793311,
      31.263962,
      1.289763,
      35,
      NULL,
      15,
      1,
      NULL,
      46.920864,
      164,
      50,
      137.094726,
      63.764458,
      45.075556,
      '10-15-2003',
      63,
      NULL,
      19,
      8.412491,
      144,
      NULL,
      '10-24-1999',
      NULL,
      0.848335,
      1.047880,
      4,
      1.015176,
      0,
      0.179512,
      2.997640,
      0,
      0,
      3.258951,
      1.998504,
      1,
      1,
      0,
      NULL,
      1.984783,
      0.934441,
      0,
      1.953651,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.914615,
      NULL,
      3.508667,
      9,
      4.376346,
      NULL,
      0.187269,
      0.555528,
      123.180335,
      1.418682,
      3,
      0.414620,
      NULL,
      NULL,
      35.681587,
      NULL,
      NULL,
      NULL,
      ' 0-12-1995',
      NULL,
      NULL,
      16,
      49.890616,
      61.284453,
      96.917982,
      30.992159,
      NULL,
      77.645921,
      36.833296,
      NULL,
      87,
      ' 3-12-1990',
      11,
      27,
      16,
      NULL,
      NULL,
      NULL,
      2,
      ' 4-14-1991',
      10,
      4.831534,
      NULL,
      10.114083,
      21.693633,
      14,
      15.611023,
      15.253622,
      8.877050,
      1,
      NULL,
      1,
      NULL,
      1.072220,
      NULL,
      25.043388,
      29,
      1,
      2.010972,
      1.234815,
      1.901630,
      ' 4- 4-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      46.677716,
      6,
      ' 9-19-2000',
      NULL,
      NULL,
      NULL,
      40.904784,
      NULL,
      NULL,
      ' 7-10-1989',
      4,
      8,
      ' 7-21-1980',
      NULL,
      17.158073,
      ' 4-16-1978',
      5,
      12.575817,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      12.315956,
      ' 4-17-1987',
      37.061945,
      11,
      8.818165,
      NULL,
      4.284402,
      235.607962,
      ' 4- 8-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


