set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9616650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3140',
      '22431342',
      '30241104',
      NULL,
      NULL,
      '04103140',
      NULL,
      '01443003',
      '04013113',
      '02212111',
      '31330134',
      '43001204',
      NULL,
      '42131311',
      '31320011',
      '30012234',
      NULL,
      NULL,
      '24212410',
      NULL,
      '43004321',
      '20002311',
      '12213202',
      '13004312',
      '11101012',
      '41220022',
      NULL,
      '40401142',
      '34240002',
      '30122144',
      NULL,
      '22203324',
      '40400341',
      '30002242',
      '01341301',
      '00230302',
      '23401143',
      '13241304',
      '41003043',
      NULL,
      '33132423',
      '44210143',
      '41413401',
      NULL,
      '12444033',
      '141',
      '34',
      NULL,
      7,
      '4422444',
      1.237030,
      NULL,
      NULL,
      NULL,
      '110033',
      0,
      ' 2-19-1990',
      ' 0-25-1982',
      NULL,
      NULL,
      NULL,
      1.183685,
      15,
      NULL,
      34,
      8.496617,
      2.537205,
      4.104669,
      12.491426,
      7,
      6.793135,
      NULL,
      28.872859,
      NULL,
      NULL,
      21.339497,
      22.244804,
      7,
      19.239975,
      NULL,
      19,
      12,
      NULL,
      67.740937,
      150.973132,
      55.870882,
      36.882967,
      92,
      192.088559,
      ' 5- 8-1995',
      19,
      26.326397,
      NULL,
      41.447645,
      NULL,
      NULL,
      ' 6- 8-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.709584,
      4.357090,
      7.313355,
      NULL,
      2.728507,
      ' 9-10-1988',
      1,
      0.995357,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      9.960564,
      NULL,
      NULL,
      NULL,
      '11-27-1974',
      30.854732,
      32.883887,
      NULL,
      49.163225,
      97.284681,
      72,
      21,
      NULL,
      33.448520,
      21,
      21.500102,
      68,
      ' 4-23-1991',
      23,
      15,
      23.044516,
      2,
      38,
      NULL,
      8,
      ' 7-25-1981',
      26.949019,
      16.336609,
      ' 7- 9-1999',
      11.095117,
      21,
      30.031746,
      NULL,
      9.285377,
      0,
      NULL,
      NULL,
      NULL,
      102,
      NULL,
      NULL,
      19.648201,
      0,
      0.448537,
      0.076558,
      NULL,
      0.043870,
      '11-24-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11-17-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.568032,
      NULL,
      11,
      6,
      ' 6-11-2001',
      174.944338,
      123.618684,
      ' 5- 7-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      21,
      NULL,
      46.577475,
      5.820132,
      NULL,
      ' 4-26-1997',
      NULL,
      24.203682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


