set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8040329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3311',
      '03234142',
      NULL,
      '23330011',
      '23001210',
      '01034131',
      '21443123',
      '21123333',
      '44022013',
      '20241022',
      '44124022',
      '31114124',
      '00320134',
      '43342011',
      '20203340',
      '43330340',
      NULL,
      '23320114',
      '23112014',
      '20211131',
      '40401133',
      '01243241',
      '03021344',
      '11142234',
      '34133101',
      '22031333',
      NULL,
      NULL,
      NULL,
      '41114431',
      NULL,
      '21421441',
      NULL,
      '30043031',
      NULL,
      '22120112',
      NULL,
      '14412440',
      '24401014',
      '13234204',
      '02144242',
      '21302300',
      '42430303',
      '41014314',
      '00033243',
      '002',
      '22',
      NULL,
      NULL,
      '4340040',
      NULL,
      1.420159,
      1,
      NULL,
      '020001',
      4.747538,
      NULL,
      NULL,
      54.452046,
      NULL,
      10,
      11,
      NULL,
      9,
      37.172894,
      14,
      24.267583,
      17.879389,
      8,
      5,
      31.361019,
      15,
      27,
      26,
      0.352175,
      20.052240,
      0,
      10,
      11.726710,
      17.958254,
      49,
      9.912300,
      0,
      68.196375,
      148,
      21.237848,
      112.308547,
      75,
      64,
      ' 4-16-2002',
      NULL,
      31.721242,
      12.548095,
      NULL,
      106,
      105,
      ' 1-21-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.941615,
      NULL,
      8,
      17,
      6,
      3,
      ' 9- 7-1986',
      0.388850,
      1,
      29,
      NULL,
      NULL,
      63,
      1,
      0,
      21.843009,
      NULL,
      NULL,
      NULL,
      ' 4- 6-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.757816,
      2.922842,
      7,
      35.319322,
      2,
      14,
      2,
      ' 8-19-1985',
      14.189128,
      NULL,
      ' 7-18-1981',
      NULL,
      NULL,
      7,
      0.064127,
      13.082935,
      4,
      1.569815,
      5,
      1,
      74,
      4.507914,
      0.382373,
      NULL,
      NULL,
      0.329905,
      NULL,
      2,
      NULL,
      ' 3- 8-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      99,
      12,
      ' 2-14-1979',
      NULL,
      NULL,
      NULL,
      44.495966,
      '11-11-1988',
      27.581593,
      ' 3-21-2001',
      5,
      NULL,
      '11-17-1988',
      NULL,
      30,
      NULL,
      NULL,
      0,
      ' 3- 6-1991',
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      ' 3-17-1999',
      NULL,
      16.414849,
      13,
      ' 4-29-1979',
      0,
      25.976731,
      '11-27-1974',
      9.921007,
      NULL,
      13,
      6.774664,
      ' 0-26-2000',
      NULL,
      1.145801,
      143,
      ' 8-27-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


