set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8040329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0210',
      '41210121',
      NULL,
      NULL,
      '12223001',
      '12324114',
      '30040213',
      NULL,
      '24003433',
      '03342242',
      '32130131',
      NULL,
      NULL,
      NULL,
      '43144122',
      '12400410',
      '41240140',
      '42342033',
      '12314142',
      '00442104',
      NULL,
      '02322131',
      '34330044',
      '23430414',
      '14020004',
      '40123111',
      '14231131',
      '31010424',
      NULL,
      '43202200',
      '41133104',
      '10130034',
      '00404110',
      NULL,
      '30024331',
      NULL,
      '34102422',
      '04021221',
      '30001434',
      '21420113',
      '42012324',
      NULL,
      '14003404',
      '44440300',
      NULL,
      '241',
      NULL,
      14,
      9.928126,
      '3144344',
      2,
      37.684543,
      2,
      NULL,
      '424304',
      4.707122,
      ' 5- 8-1996',
      '10-26-2002',
      NULL,
      57,
      14,
      NULL,
      NULL,
      13.958375,
      NULL,
      11,
      8,
      8,
      10,
      10.438574,
      25.507558,
      NULL,
      NULL,
      NULL,
      14.380207,
      4.631417,
      29.962401,
      20,
      68,
      NULL,
      NULL,
      NULL,
      NULL,
      74,
      NULL,
      98,
      86.643488,
      153,
      NULL,
      ' 7- 4-1987',
      43,
      NULL,
      11.733660,
      28.762984,
      44.885590,
      121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      5.379731,
      4.793068,
      NULL,
      0.158342,
      3.213554,
      ' 9-25-1986',
      1,
      0,
      25,
      1,
      NULL,
      90.716623,
      0,
      1,
      66.914032,
      NULL,
      NULL,
      NULL,
      ' 1- 4-2001',
      2,
      15,
      61.880005,
      NULL,
      NULL,
      18.733131,
      38.731148,
      57.550343,
      56,
      54.599089,
      40.754198,
      NULL,
      '10-29-2000',
      10,
      8.215070,
      1,
      NULL,
      11,
      1,
      1.665819,
      ' 7- 0-2001',
      7,
      25,
      '10-27-1977',
      9.241975,
      NULL,
      0,
      11.576431,
      10,
      0.996861,
      0.483437,
      8.376182,
      NULL,
      30,
      NULL,
      NULL,
      17.109621,
      18,
      NULL,
      NULL,
      1.318696,
      0.925296,
      ' 3- 0-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      119.743500,
      NULL,
      ' 2- 5-1985',
      NULL,
      NULL,
      NULL,
      33.925635,
      ' 3-27-1975',
      26.891121,
      ' 3-27-1975',
      NULL,
      16,
      ' 1-16-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      25,
      '10-16-1976',
      51,
      45,
      53,
      ' 0-21-1992',
      0.927077,
      56.356071,
      ' 3- 7-1997',
      NULL,
      NULL,
      NULL,
      18,
      ' 0-27-2003',
      NULL,
      NULL,
      26.232068,
      ' 0-26-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


