set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8040329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '0',
      NULL,
      '3',
      NULL,
      '0',
      '4',
      '2',
      '1',
      '2',
      NULL,
      '0',
      '2',
      '4',
      '2',
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      '2',
      '',
      '0',
      '',
      '0',
      '4',
      NULL,
      NULL,
      '0',
      '',
      '',
      '4',
      '4',
      NULL,
      '0',
      '3',
      '0',
      '3',
      NULL,
      '1',
      '1',
      '4',
      NULL,
      '22',
      NULL,
      49,
      NULL,
      3,
      66,
      2,
      NULL,
      '421333',
      5.069517,
      NULL,
      '11-26-1983',
      100.299565,
      NULL,
      15,
      18,
      33.727337,
      6.334433,
      86,
      3,
      18.005149,
      8.697397,
      6,
      17,
      34,
      4,
      NULL,
      NULL,
      15,
      17,
      5.323507,
      5,
      59,
      7.482314,
      86,
      16,
      1,
      11,
      193.387224,
      66.939419,
      132,
      NULL,
      160.385116,
      '10- 2-1985',
      26.829706,
      0.831526,
      17.062782,
      NULL,
      NULL,
      158,
      ' 4- 1-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42,
      6,
      4,
      2,
      2.663289,
      0,
      ' 7-17-1975',
      0.456044,
      0.177417,
      128.269794,
      0,
      1.420089,
      NULL,
      0,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      ' 0-25-1977',
      51,
      55.016152,
      34.983973,
      NULL,
      32.876356,
      69.991537,
      48,
      80.958995,
      60.880148,
      67.951113,
      NULL,
      18.795754,
      ' 8-28-1980',
      2.914986,
      0,
      14.626320,
      6,
      13.903755,
      15,
      6,
      ' 3-13-1992',
      5.627168,
      3,
      ' 9-10-1998',
      NULL,
      11,
      15.602235,
      7,
      20,
      NULL,
      0,
      16.627562,
      1.106228,
      66,
      1,
      1,
      4.630692,
      9,
      1,
      NULL,
      3,
      NULL,
      '11- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      108.062842,
      8,
      ' 8- 2-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      '10-12-1975',
      17,
      ' 2-19-1999',
      0,
      NULL,
      ' 9- 0-1979',
      NULL,
      20.974735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      ' 9- 0-1984',
      12.150080,
      59.032742,
      34,
      ' 5-22-2002',
      0.666400,
      50.666576,
      ' 1- 4-1974',
      NULL,
      NULL,
      NULL,
      23.648275,
      ' 2-26-1984',
      NULL,
      1,
      170.622734,
      ' 4-10-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


