set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8832931';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0403',
      '12332303',
      NULL,
      '30103422',
      '13231320',
      '33300120',
      '20410414',
      '04440340',
      '33401121',
      '10024231',
      '00143231',
      NULL,
      NULL,
      '11013032',
      '00431212',
      '42423204',
      '13231141',
      '21201400',
      '20010002',
      '00312000',
      '34241023',
      '10402043',
      NULL,
      '43204434',
      '32130203',
      '32023200',
      '23134044',
      '40142000',
      '12134444',
      '10400232',
      '40342023',
      '23011111',
      '01013331',
      '24011343',
      '10003122',
      '10322210',
      '23313220',
      '13431420',
      NULL,
      '04340212',
      '14110220',
      '41111041',
      '01122240',
      '30200113',
      '34133242',
      '434',
      '20',
      NULL,
      NULL,
      '0342340',
      0.382203,
      1.564323,
      0,
      NULL,
      NULL,
      NULL,
      ' 7- 1-2001',
      NULL,
      27,
      NULL,
      20,
      17,
      5,
      4,
      33.256394,
      0,
      NULL,
      18.514847,
      NULL,
      1.003174,
      NULL,
      3,
      10,
      7,
      14,
      11,
      3.212216,
      NULL,
      59.137764,
      NULL,
      1.958977,
      NULL,
      0.762576,
      31.074791,
      9,
      14.121392,
      41,
      138,
      128,
      ' 2- 3-1998',
      17.069568,
      11,
      0.026189,
      NULL,
      48.435120,
      54,
      NULL,
      0.669798,
      3.507980,
      2,
      0,
      5.666703,
      2.174347,
      5,
      1.977237,
      1.576380,
      1.489379,
      NULL,
      1.064950,
      1.444542,
      0,
      0.315840,
      0.651691,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      6.076516,
      0,
      3,
      '11-27-2001',
      NULL,
      1.935090,
      26.609612,
      NULL,
      0.184890,
      108,
      1.847688,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-25-1995',
      17.816878,
      22,
      NULL,
      13.512977,
      114.593269,
      21,
      62.403577,
      29.226218,
      3,
      78,
      21.563522,
      97.424345,
      ' 4-10-1977',
      33.494804,
      17,
      1.607303,
      7.701220,
      24.135151,
      NULL,
      6.936437,
      ' 4-15-2001',
      22,
      15,
      NULL,
      2.825270,
      6.990094,
      5.137979,
      NULL,
      3.736099,
      4,
      NULL,
      8.616670,
      1,
      85,
      1,
      NULL,
      NULL,
      5.648658,
      4,
      4,
      1,
      0,
      '10- 2-1991',
      0.861919,
      NULL,
      1,
      ' 3-28-1986',
      12,
      33.032448,
      ' 8- 7-1990',
      2.235770,
      44.082725,
      ' 4-21-1975',
      NULL,
      ' 8-18-1976',
      NULL,
      ' 0-18-1983',
      7.882086,
      3,
      ' 4- 7-1981',
      81.691594,
      11,
      ' 3-13-1993',
      7.026176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      18.546093,
      '10- 2-2001',
      8.877191,
      3,
      11.668292,
      ' 9- 6-1976',
      0,
      96,
      ' 8-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015527);
commit;
end;
/


