set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9432591';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2221',
      '24424011',
      '10020103',
      NULL,
      '13030022',
      '34331110',
      '32240413',
      '42343341',
      '01413010',
      '12013232',
      '01044410',
      '13321210',
      '22102124',
      '31424124',
      '30110310',
      '44321232',
      '34143401',
      '10134342',
      NULL,
      '32133442',
      '13313010',
      '20224121',
      '04101421',
      '22313043',
      '30221002',
      '04230011',
      '13231433',
      NULL,
      '02411212',
      '30040041',
      '13020243',
      NULL,
      '11233411',
      '31424123',
      '22243403',
      NULL,
      '31300444',
      '40031103',
      '11343223',
      '13442222',
      NULL,
      '40304113',
      '43243424',
      '33223100',
      '02402133',
      '213',
      '00',
      4,
      23.394426,
      '2010011',
      0.275971,
      0,
      0,
      NULL,
      '340300',
      4,
      '11-19-1976',
      '11-21-1977',
      13.027159,
      NULL,
      10,
      0.672012,
      44.931512,
      6.484082,
      7,
      14,
      21,
      2.646565,
      6.665399,
      11.180935,
      4.261429,
      22,
      NULL,
      11,
      16.254994,
      10.606989,
      7.683644,
      23.425980,
      59.708664,
      13.222570,
      96.563601,
      2,
      1,
      42,
      NULL,
      42.058654,
      157,
      98,
      169,
      ' 2- 3-1981',
      NULL,
      NULL,
      17,
      NULL,
      155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      30.229678,
      3.996540,
      3.993907,
      24,
      NULL,
      NULL,
      0.386180,
      NULL,
      113.654274,
      0.261700,
      0.694617,
      31.419583,
      1.036469,
      0,
      19,
      NULL,
      NULL,
      NULL,
      ' 7-12-1979',
      75,
      59,
      20.442482,
      82.287146,
      85,
      111,
      36,
      47,
      45.548658,
      42,
      12,
      30.396560,
      ' 1-17-1985',
      1.815721,
      NULL,
      4,
      NULL,
      11.363377,
      128.243728,
      11.207239,
      ' 4- 7-1980',
      0,
      2.269819,
      ' 4-26-1994',
      NULL,
      11.370501,
      18.200984,
      13,
      3,
      NULL,
      0.421949,
      10,
      1,
      88,
      0,
      2.767282,
      10.598755,
      31.045310,
      1.448742,
      1,
      1.206532,
      0,
      '11- 6-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      141.316456,
      11,
      '10- 8-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-19-2003',
      27,
      ' 4- 0-1980',
      17.227521,
      4,
      ' 9- 2-1996',
      75.540549,
      41,
      ' 4-27-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      12.754953,
      ' 8- 4-1974',
      51,
      25,
      NULL,
      ' 0-15-2001',
      2.869369,
      49,
      ' 4-12-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


