set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217527';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '1',
      '0',
      '4',
      '2',
      '2',
      '2',
      '1',
      '2',
      '3',
      NULL,
      '2',
      '3',
      '2',
      '4',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '3',
      '',
      '3',
      '1',
      '3',
      '1',
      '3',
      '',
      '',
      NULL,
      '3',
      '3',
      '0',
      '4',
      '0',
      '2',
      '3',
      NULL,
      '0',
      NULL,
      '021',
      '14404412',
      15,
      4,
      NULL,
      3.201027,
      2,
      0,
      NULL,
      NULL,
      3.453830,
      ' 3-19-1981',
      ' 2- 9-1984',
      78,
      239,
      NULL,
      3,
      22,
      9,
      3.154863,
      0,
      2.807747,
      NULL,
      6,
      NULL,
      29,
      15,
      NULL,
      16.724555,
      16.777474,
      17,
      2.773839,
      4.238208,
      NULL,
      12,
      41,
      8.241540,
      NULL,
      90.608232,
      111.251338,
      91.899037,
      32.782573,
      94.119739,
      NULL,
      ' 1- 6-1984',
      16,
      36.347087,
      22.977169,
      10.655086,
      136.294995,
      195,
      '10- 4-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      29.235191,
      7.247372,
      4,
      3,
      0,
      ' 0- 3-1985',
      1.060842,
      1.252645,
      NULL,
      1,
      NULL,
      94.980446,
      0.506047,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      6,
      NULL,
      13.787755,
      2.668936,
      4.068013,
      61,
      11,
      62,
      21.841177,
      NULL,
      NULL,
      ' 2- 4-1979',
      15,
      4,
      13,
      43,
      34.749949,
      8,
      6,
      ' 3- 2-1990',
      11,
      1,
      ' 9-19-1992',
      7.771897,
      9.481504,
      11,
      2,
      NULL,
      6,
      0,
      5,
      3,
      20,
      0,
      NULL,
      3.035491,
      NULL,
      NULL,
      10,
      1.932296,
      0.135277,
      '10-22-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      '11-12-2002',
      NULL,
      NULL,
      NULL,
      41,
      NULL,
      29.669587,
      '10- 4-1974',
      2,
      5,
      ' 1-10-1977',
      60.002179,
      62,
      ' 4-29-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      9,
      ' 0-11-1999',
      64,
      26.541677,
      6,
      ' 7- 2-1991',
      3,
      186,
      ' 6- 5-2000',
      NULL,
      7.277975,
      22,
      NULL,
      ' 4-22-2001',
      42,
      0.954895,
      177,
      ' 7- 8-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


