set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9217527';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '2',
      '3',
      '0',
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4',
      '0',
      '0',
      '3',
      '4',
      '2',
      NULL,
      '4',
      '0',
      '4',
      NULL,
      '0',
      '3',
      '0',
      '',
      '0',
      '',
      '3',
      '3',
      '3',
      NULL,
      '2',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      '0',
      '1',
      '0',
      '2',
      '3',
      '2',
      '243',
      '23014002',
      14,
      53,
      '4240013',
      1.729668,
      NULL,
      3,
      0,
      '434222',
      2,
      NULL,
      NULL,
      NULL,
      67,
      15,
      9,
      5,
      NULL,
      19.662528,
      13,
      NULL,
      NULL,
      32.779532,
      8.340740,
      15,
      16.792945,
      15,
      3.332415,
      15,
      11,
      10.659128,
      9.415688,
      31,
      16,
      33,
      6,
      0,
      22.964494,
      29,
      71,
      16.036858,
      NULL,
      NULL,
      ' 7-28-1998',
      26.818460,
      0.085214,
      7.988786,
      NULL,
      5,
      48,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.076333,
      5.928814,
      11.898571,
      NULL,
      ' 1-25-1978',
      2,
      0.868314,
      122.048553,
      0,
      NULL,
      39.695211,
      NULL,
      NULL,
      31,
      NULL,
      NULL,
      NULL,
      ' 5-27-1983',
      36.019339,
      51,
      52,
      26.699912,
      8.832429,
      12.141041,
      NULL,
      31,
      80.953924,
      NULL,
      4.987453,
      48.258003,
      '11-21-1985',
      13.967742,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959539,
      4,
      '11-22-1990',
      7.864058,
      NULL,
      ' 3-25-1994',
      2,
      6.771971,
      4.163926,
      0.595024,
      9,
      7.453270,
      0.381388,
      2,
      0.817278,
      49,
      3,
      1,
      5.249553,
      4.716586,
      1,
      5,
      1,
      1,
      ' 7-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      1.818808,
      11,
      ' 6-20-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-29-2002',
      19.931350,
      ' 4-11-1988',
      9.835877,
      10.945846,
      ' 1-22-1999',
      NULL,
      45.254093,
      ' 6-11-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      ' 5-15-1974',
      12.456721,
      26,
      24.800039,
      '10-19-1995',
      1.692022,
      21.943190,
      NULL,
      5,
      13,
      2.045540,
      NULL,
      NULL,
      NULL,
      1.069274,
      7,
      '11-13-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


