set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8214753';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2234',
      '01301304',
      '13332000',
      NULL,
      '10443240',
      '22133021',
      NULL,
      NULL,
      NULL,
      '14043134',
      '01444313',
      '30013024',
      '30233104',
      '44421444',
      '43342320',
      '30034304',
      '32423102',
      '11412230',
      '10012221',
      '31330410',
      '30442323',
      '03033432',
      NULL,
      '32024023',
      NULL,
      '14432421',
      NULL,
      '43330414',
      '03131130',
      '40203344',
      NULL,
      '14304143',
      '24323243',
      '02431240',
      '30424321',
      '24422232',
      NULL,
      '02240321',
      '33331223',
      '21031113',
      '02220333',
      NULL,
      '44202030',
      '24334132',
      '10413412',
      NULL,
      '43',
      NULL,
      NULL,
      '2120332',
      3,
      NULL,
      3,
      NULL,
      '413424',
      3,
      '10-18-1999',
      ' 5-20-1989',
      60.151781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40,
      13,
      22.482667,
      12,
      21.572909,
      NULL,
      26.376897,
      14.727864,
      21.846202,
      8.780817,
      NULL,
      4,
      6.082759,
      7,
      40,
      5,
      41.949822,
      NULL,
      NULL,
      41.366998,
      194.803360,
      NULL,
      166.942333,
      139,
      87.345301,
      ' 1-19-1997',
      NULL,
      42.295954,
      7.225867,
      NULL,
      6.267219,
      53.674153,
      ' 4- 8-1976',
      1,
      2.072195,
      2.714410,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307827,
      NULL,
      3.342243,
      1,
      0.846848,
      1.126968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 6-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-18-1992',
      NULL,
      56.133376,
      25.166016,
      0.904367,
      115,
      57.841540,
      49.233289,
      43.853703,
      NULL,
      19,
      NULL,
      14,
      '11- 0-1995',
      14,
      37,
      10,
      55,
      2.834083,
      77.058487,
      11,
      ' 7-27-1988',
      11.770966,
      1.234554,
      ' 5-26-1993',
      8.763993,
      13.094963,
      10,
      26,
      0.862585,
      14.840996,
      0,
      NULL,
      0.561064,
      21.518244,
      1.735826,
      4.729839,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39.243438,
      NULL,
      15,
      NULL,
      3.882039,
      NULL,
      ' 8-24-1974',
      15.993383,
      12.084776,
      2.858769,
      5.799492,
      ' 6-26-2001',
      50,
      NULL,
      91.856354,
      '11- 6-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.566324,
      NULL,
      NULL,
      62.528038,
      0,
      3.304907,
      5.494029,
      0.017902,
      8.400243,
      NULL,
      1,
      0.660907,
      NULL,
      NULL,
      1.006536,
      44,
      0,
      1.387605,
      73.236877,
      5.353941,
      NULL,
      107,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.220057,
      NULL,
      NULL,
      1.940761,
      1.954642,
      14.138398,
      1,
      NULL,
      0,
      47,
      0,
      NULL,
      7.841440,
      NULL,
      NULL,
      NULL,
      NULL,
      36.197850,
      11,
      19.671822,
      NULL,
      NULL,
      29.397523,
      NULL,
      0.276965,
      NULL,
      0.661543,
      NULL,
      5,
      1,
      0,
      1.275071,
      NULL,
      '11- 3-2000',
      NULL,
      '10-19-1991',
      ' 4-19-2002',
      NULL,
      ' 2-25-1986',
      ' 9- 1-1992',
      NULL);
commit;
end;
/


