set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '4',
      '2',
      '3',
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '0',
      NULL,
      '0',
      '3',
      '4',
      '3',
      '4',
      '4',
      '1',
      '1',
      '1',
      NULL,
      NULL,
      '1',
      '',
      NULL,
      '',
      '3',
      NULL,
      '1',
      '2',
      '4',
      NULL,
      '',
      '0',
      '3',
      '2',
      NULL,
      '3',
      '2',
      '4',
      '4',
      '4',
      '0',
      '2',
      '322',
      '02032240',
      6,
      50.562636,
      '4401431',
      0.026646,
      0.715063,
      0,
      NULL,
      '204043',
      5,
      ' 9- 1-1998',
      ' 2-18-2003',
      85.567127,
      185,
      29,
      NULL,
      NULL,
      4,
      41.694004,
      14.270254,
      11.198513,
      9.119647,
      17,
      14.865991,
      23,
      0,
      NULL,
      0.581133,
      8.928304,
      6,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      7,
      1,
      NULL,
      NULL,
      10,
      186.263339,
      NULL,
      167.120675,
      NULL,
      46,
      13.317811,
      NULL,
      16.213517,
      129,
      77.038139,
      ' 3-26-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      36,
      NULL,
      5.026857,
      71.043535,
      0.456532,
      ' 1-13-2001',
      NULL,
      0.554247,
      210,
      NULL,
      1.655512,
      119,
      1.117362,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1990',
      NULL,
      68.168908,
      84.609951,
      37,
      40,
      40,
      NULL,
      NULL,
      6.324152,
      NULL,
      NULL,
      NULL,
      ' 8-21-1974',
      4,
      3,
      21,
      21.269640,
      46,
      24,
      NULL,
      ' 8-11-2001',
      19.888041,
      6.565026,
      ' 8-12-1998',
      12.775972,
      5.540325,
      5.693481,
      NULL,
      20,
      4,
      1,
      18.321932,
      0,
      73.388946,
      1,
      1.058122,
      13.002526,
      6.151012,
      0,
      0,
      1,
      NULL,
      ' 1- 1-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      '10-18-2002',
      9,
      NULL,
      11,
      NULL,
      ' 1-25-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      ' 1-23-1979',
      NULL,
      14.556761,
      1,
      NULL,
      1,
      41,
      ' 6- 9-1975',
      NULL,
      11.921299,
      6,
      27,
      '10- 6-1988',
      61.884599,
      1,
      NULL,
      '11- 7-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


