set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9788125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '4',
      '4',
      NULL,
      NULL,
      '4',
      '3',
      '4',
      '4',
      '0',
      '2',
      '2',
      '4',
      '3',
      '1',
      NULL,
      '0',
      '2',
      '0',
      '0',
      NULL,
      '3',
      '3',
      '',
      '3',
      '',
      '1',
      NULL,
      '3',
      '1',
      '0',
      '',
      NULL,
      '3',
      '0',
      '4',
      NULL,
      '2',
      '4',
      '1',
      '1',
      '0',
      '1',
      '4',
      '202',
      '41240131',
      1,
      6.008685,
      '0412424',
      2.125957,
      NULL,
      0,
      1,
      '401440',
      5,
      NULL,
      NULL,
      52.815360,
      228,
      NULL,
      NULL,
      15,
      2.147014,
      27,
      11,
      NULL,
      NULL,
      31,
      8.130083,
      2,
      0.716867,
      11,
      3.212286,
      NULL,
      4,
      22,
      0,
      NULL,
      NULL,
      NULL,
      20,
      1.505960,
      17,
      8.556407,
      64,
      17.654701,
      69.989198,
      164.547426,
      NULL,
      37,
      21,
      15,
      NULL,
      65.920968,
      NULL,
      ' 6-21-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      17.564433,
      10.202876,
      4,
      2.306878,
      1,
      ' 8-27-1976',
      3,
      0,
      180,
      0,
      1.391936,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 8-1987',
      NULL,
      9.809871,
      53.533193,
      7.077611,
      41.161020,
      75.274808,
      54.269270,
      37.693976,
      40,
      28.695460,
      29.863647,
      38.704527,
      ' 7-29-1991',
      2,
      1.054541,
      23.287685,
      8.577954,
      28.178178,
      NULL,
      0,
      ' 1-10-1993',
      0.844236,
      NULL,
      ' 6-13-2003',
      NULL,
      7.551901,
      2.097207,
      6,
      21.238834,
      1.934023,
      NULL,
      NULL,
      0.230296,
      NULL,
      0.168953,
      1,
      22,
      NULL,
      1,
      0.094242,
      0.051906,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      39.813937,
      ' 7- 0-2001',
      NULL,
      6,
      '10-13-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      ' 1-21-1983',
      24,
      11.058699,
      15,
      ' 9- 8-2003',
      0,
      NULL,
      '11- 0-1984',
      NULL,
      44,
      22,
      57,
      ' 6-12-1989',
      46.696431,
      0,
      88,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


