set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8633212';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '02420004',
      '33142122',
      '01443322',
      NULL,
      '04020400',
      NULL,
      NULL,
      '42233144',
      '32321211',
      '04110404',
      '20000210',
      '32111321',
      '11411110',
      '24144134',
      '13034441',
      '21420301',
      '31232014',
      '23211114',
      '24040110',
      NULL,
      NULL,
      '22034324',
      '21333041',
      '02114021',
      NULL,
      '42203034',
      '14321111',
      '00224013',
      '43230204',
      '04224014',
      '24402420',
      NULL,
      NULL,
      '24220123',
      '21410233',
      NULL,
      NULL,
      '20313442',
      NULL,
      '01033302',
      '20312402',
      '31023423',
      NULL,
      '24213341',
      NULL,
      '12',
      NULL,
      NULL,
      '4231422',
      3,
      NULL,
      1,
      NULL,
      '212221',
      3,
      ' 8-24-1979',
      NULL,
      18.669873,
      NULL,
      25.799547,
      21,
      19.450989,
      NULL,
      16,
      16,
      30.395241,
      11,
      57,
      31,
      33.061942,
      1,
      4.238472,
      20,
      2.769883,
      19,
      12.473853,
      27.020722,
      NULL,
      4.034191,
      27.492221,
      12,
      1,
      NULL,
      102.460363,
      NULL,
      39.170934,
      NULL,
      5.204126,
      '10-10-1983',
      55.880489,
      6,
      8.745388,
      31.320265,
      NULL,
      70,
      ' 6-26-1975',
      NULL,
      NULL,
      4.459741,
      1,
      0.326486,
      1,
      4,
      1,
      0,
      1,
      2.882112,
      1,
      NULL,
      0.664736,
      0,
      0.652995,
      1.721573,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-15-1989',
      53.382944,
      14,
      28.961451,
      1.709740,
      NULL,
      7,
      ' 4- 9-1985',
      2,
      0.567636,
      7,
      1.744655,
      1,
      NULL,
      1,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      '10- 5-1978',
      102,
      NULL,
      62,
      41.710996,
      65,
      NULL,
      64.589117,
      NULL,
      42,
      43,
      88.777627,
      92,
      NULL,
      NULL,
      NULL,
      5,
      39.941579,
      33.917793,
      NULL,
      NULL,
      ' 0-15-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      70.150829,
      NULL,
      '10-22-1998',
      NULL,
      NULL,
      NULL,
      20,
      '11-17-1998',
      15,
      ' 0- 9-1974',
      5.674124,
      9.247064,
      ' 0-29-1990',
      43,
      117,
      ' 0- 9-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      14.047099,
      '10-12-1975',
      42.442739,
      21,
      40,
      ' 5-15-1996',
      1,
      131.632298,
      '11- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


